// Karma configuration
module.exports = function(config) {
  config.set({

    basePath: './', 

    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['jasmine-jquery', 'jasmine'],


    // list of files / patterns to load in the browser
    files: [
      'node_modules/mathjs/dist/math.min.js',
      'lib/bin/EnumDefinitions.js',
      'lib/bin/issm-binaries.js',
      'lib/bin/issm-extlibraries.js',
      'lib/bin/matlabfunc.js',
      'lib/Exp/Square.js',
      'lib/Par/SquareShelfConstrained.js',
      'lib/Data/SquareShelfConstrained.data.js',
      'lib/bin/mesh2d.js',
      'lib/bin/mesh3dprisms.js',
      'lib/bin/levelset.js',
      'lib/bin/mask.js',
      'lib/bin/geometry.js',
      'lib/bin/friction.js',
      'lib/bin/inversion.js',
      'lib/bin/SMBforcing.js',
      'lib/bin/initialization.js',
      'lib/bin/flowequation.js',
      'lib/bin/stressbalance.js',
      'lib/bin/thermal.js',
      'lib/bin/masstransport.js',
      'lib/bin/calving.js',
      'lib/bin/hydrologyshreve.js',
      'lib/bin/matice.js',
      'lib/bin/damage.js',
      'lib/bin/qmu.js',
      'lib/bin/basalforcings.js',
      'lib/bin/project3d.js',
      'lib/bin/model.js',
      //'scripts/specs/temp.spec.js'
      'scripts/specs/issm-ajax.spec.js'
      //'scripts/specs/3.spec.js'
    ],

    // list of files to exclude
    exclude: [
    ],


    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
    },


    // test results reporter to use
    // possible values: 'dots', 'progress'
    // available reporters: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['dots', 'junit'],
    junitReporter: {
        outputFile: 'test-results.xml'
    },


    // web server port
    port: 9876,


    // enable / disable colors in the output (reporters and logs)
    colors: true,


    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: true,


    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    //browsers: ['Chrome'],
    browsers: ['Chrome'],


    // Continuous Integration mode
    // if true, Karma captures browsers, runs the tests and exits
    singleRun: true,

    // Concurrency level
    // how many browser should be started simultaneous
    concurrency: Infinity
  });
};
