function  [x,y]=mapll(lat,lon,hem);
%MAPLL - convert latitude and longitude into x and y
%
%   latitude and longitude are in degrees.
%   Hemisphere must be 1 for north and 0 for south
%
%   Usage:
%      [x,y]=mapll(latitude,longitude,hemisphere)
%
%   See also MAPXY, LL2XY

%some corrections
lon=lon+360;       % to have 0<lon<360

%WGS84
re=6378137.0;
e2= 0.00669437999015;
e=sqrt(e2);

%Standard parallel - latitude with no distortion = -71.
if hem==1,
	%Northern hemisphere
	sn=1;
	slat=70;
	xlam=45;
else
	%Southern Hemisphere
	sn=-1.0;
	slat=71;
	xlam=0;
end

lat=sn*lat*pi/180;
lon=lon*pi/180;

rlat=lat;
slat=slat/180*pi;
xlam=xlam/180*pi;

t1=tan(pi/4.-rlat/2.)./((1.0-e*sin(rlat))./...
(1.0+e*sin(rlat))).^(e/2.);

t2=tan(pi/4.-slat/2.)./((1.0-e*sin(slat))./...
(1.0+e*sin(slat))).^(e/2.);

cm=cos(slat)./sqrt(1.0-e2*(sin(slat).^2));
rho=re*cm.*t1./t2;
x= rho*sn.*sin((lon+xlam));
y=-rho*sn.*cos((lon+xlam));
