function applyoptions(md,data,datatype,options,canvas,gl,node){
	//APPLYOPTIONS - apply colobar, text, cloud, and expdisp options to current plot
	//
	//   Usage:
	//      applyoptions(md,data,options)
	//
	//   See also: PLOTMODEL, PARSE_OPTIONS
	
	//colorbar {{{
	if (options.exist('colorbar')) {
		if (options.getfieldvalue('colorbar')==1) {
			//Handle movie data {{{
			if (datatype == 5) {
				data = data[0];
			} //}}}
			//Variable options initialization {{{
			var caxis = options.getfieldvalue('caxis',[ArrayMin(data),ArrayMax(data)]);
			var colorbarorientiation = options.getfieldvalue('colorbarorientation','vertical');
			var colorbarinnerlabels = options.getfieldvalue('colorbarinnerlabels','off');
			var cheightoffset = options.getfieldvalue('colorbarfontsize',18);
			var cwidthoffset = options.getfieldvalue('colorbarfontsize',18)*3;
			var cwidthscale = 0.5; //Default size of actual colorbar width, relative to canvas width (range [0,1])
			var cheightscale = 0.875; //Default size of actual colorbar height, relative to canvas height (range [0,1])
			var ccontext,ccanvas,ccanvasid,ccanvashtml,cheight,cwidth,color,y,x,cgradient,cmap,colorbar,textAlign,a,b,c,d,e,f,g,h;
			//}}}
			//Set colorbar lables {{{
			var labels = [];
			var cdivisions = options.getfieldvalue('colorbarnticks',6);
			var caxisdelta = caxis[1] - caxis[0];
			var clabelitem;
			var precision = options.getfieldvalue('colorbarprecision',3);
			if (options.getfieldvalue('log','off')!='off') {
				for (var i=cdivisions; i >= 0; i--) {
					var scale = (Math.log10(caxis[1])-Math.log10(caxis[0]))/Math.log10(options.getfieldvalue('log',10));
					labels[i] = (Math.pow(options.getfieldvalue('log',10),Math.log10(caxis[0])/Math.log10(options.getfieldvalue('log',10))+scale*(cdivisions-i)/cdivisions)).toPrecision(precision);
				}
			} else {
				for (var i=cdivisions; i >= 0; i--) {
					labels[i] = (caxisdelta*(cdivisions-i)/cdivisions+caxis[0]).toPrecision(precision);
				}
			} //}}}
			ccanvasid = options.getfieldvalue('colorbarid',options.getfieldvalue('canvasid')+'_colorbar');
			ccanvashtml = document.getElementById(ccanvasid);
			ccanvas = $('#'+ccanvasid);
			ccontext = ccanvas[0].getContext('2d');
			ccontext.clearRect(0,0, ccanvashtml.width, ccanvashtml.height);
			ccontext.beginPath();
			cmap = options.getfieldvalue('colormap','jet');
			colorbar = colorbars[cmap];
			//Handle orientation {{{
			if (colorbarorientiation=='vertical') {
				cwidth = ccanvashtml.width*cwidthscale*options.getfieldvalue('colorbarwidth',1);
				cheight = ccanvashtml.height*cheightscale*options.getfieldvalue('colorbarheight',1);
				cgradient = ccontext.createLinearGradient(0,cheightoffset/2,0,cheight);
				textAlign = 'left';
				a = 0;
				b = cheightoffset*3/2;
				c = 0;
			}
			else {
				cwidth = ccanvashtml.width*0.7*options.getfieldvalue('colorbarwidth',1);
				cheight = ccanvashtml.height*0.4*options.getfieldvalue('colorbarheight',1);
				cgradient = ccontext.createLinearGradient(cwidth+cwidthoffset,0,cwidthoffset,0);		
				textAlign = 'center';
				a = cwidthoffset;
				b = cheightoffset;
				c = cwidth/2+cwidthoffset;
			} //}}}
			//Handle internal labels {{{
			if (colorbarinnerlabels=='on') {
				textAlign = 'center';
				d = (cdivisions/(cdivisions+1.0));
				e = (1.0/(cdivisions+1.0));
				f = 2;
				g = 1;
				h = cwidth/2;
			}
			else {
				d = 1;
				e = 0;
				f = 1;
				g = 0;
				h = cwidth+0.2*cwidth;
			} //}}}

			for (var i=0; i < colorbar.length; i++) {
				color = colorbar[colorbar.length-i-1];
				color = [Math.round(color[0]*255),Math.round(color[1]*255),Math.round(color[2]*255)];	
				cgradient.addColorStop(i/colorbar.length*d+e,'rgba('+color.toString()+',1.0)');
			}
			ccontext.fillStyle=cgradient;
			ccontext.fillRect(a,b,cwidth,cheight);
			
			//Draw colorbar border
			ccontext.beginPath();
			ccontext.lineWidth='1';
			ccontext.strokeStyle=options.getfieldvalue('colorbarfontcolor','black');
			ccontext.rect(a,b,cwidth,cheight);
			ccontext.stroke();
			
			if (colorbarorientiation=='vertical') { //{{{
				for (var i=0; i <= cdivisions; i++) {
					y = i/(cdivisions+g)*cheight+cheightoffset/2;
					x = 0.2*cwidth;
					ccontext.font=String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
					ccontext.fillStyle=options.getfieldvalue('colorbarfontcolor','black');
					ccontext.textAlign=textAlign;
					ccontext.textBaseline='top';
					ccontext.fillText(labels[i],h,y+cheightoffset*(g+0.5));					
					ccontext.beginPath();
					ccontext.moveTo(0,y+cheightoffset*f);
					ccontext.lineTo(x,y+cheightoffset*f);
					ccontext.moveTo(cwidth-x,y+cheightoffset*f);
					ccontext.lineTo(cwidth,y+cheightoffset*f);
					ccontext.stroke();
				}
			}
			else {
				for (var i=0; i <= cdivisions; i++) {
					y = 0.2*cheight;
					x = i/cdivisions*cwidth;
					ccontext.font=String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
					ccontext.fillStyle=options.getfieldvalue('colorbarfontcolor','black');
					ccontext.textAlign=textAlign;
					ccontext.fillText(labels[cdivisions-i],x+cwidthoffset,cheight+cheightoffset*2);
					ccontext.beginPath();
					ccontext.moveTo(x+cwidthoffset,cheightoffset);
					ccontext.lineTo(x+cwidthoffset,y+cheightoffset);
					ccontext.moveTo(x+cwidthoffset,cheight-y+cheightoffset);
					ccontext.lineTo(x+cwidthoffset,cheight+cheightoffset);
					ccontext.stroke();
				}
			}
			if (options.exist('colorbartitle')) {
				ccontext.font=String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
				ccontext.fillStyle=options.getfieldvalue('colorbarfontcolor','black');
				ccontext.textAlign='left';
				ccontext.textBaseline='bottom';
				ccontext.fillText(options.getfieldvalue('colorbartitle'),c,cheightoffset);
			} //}}}
			//}}}
		} 
	}
	//}}}
	//texture canvas //{{{
	var tcontext,tcanvas,tcanvasid,tcanvashtml,tURL,tgradient;
	tcanvasid = 'texturecanvas';
	var tcanvashtml = document.getElementById(tcanvasid);
	if (tcanvashtml == null) {
		tcanvas = $('<canvas id="texturecanvas" width="256" height="256"></canvas>').insertAfter('#'+String(options.getfieldvalue('canvasid')));
		tcanvas.css({'display':'none'});
		tcanvashtml = document.getElementById(tcanvasid);
	}
	else {
		tcanvas = $('#' + tcanvasid);
	}
	tcontext = tcanvashtml.getContext('2d');
	tgradient = tcontext.createLinearGradient(0,0,0,256);
		
	var cmap = options.getfieldvalue('colormap','jet');
	var colorbar = colorbars[cmap];
	for (var i=0; i < colorbar.length; i++) {
		color = colorbar[colorbar.length-i-1];
		color = [Math.round(color[0]*255),Math.round(color[1]*255),Math.round(color[2]*255)];	
		tgradient.addColorStop(i/colorbar.length,'rgba('+color.toString()+',1.0)');
	}
	
	tcontext.fillStyle = tgradient;
	tcontext.fillRect(0,0,256,256);
	tURL = tcanvashtml.toDataURL();
	node['texture'] = initTexture(gl,tURL);
	//}}}
	//expdisp contours {{{
	if (options.exist('expdisp')) {
		canvas.nodes['expdisp'] = Node(gl,options);
		var node = canvas.nodes['expdisp'];
		
		//declare variables:  {{{
		var vertices = [];
		var indices = [];
		var colors = [];
		var rgbcolor = [];
		var xmin,xmax;
		var ymin,ymax;
		var zmin,zmax;
		var scale;
		
		//Process data and model
		var x = options.getfieldvalue('expdisp')['x'];
		var y = options.getfieldvalue('expdisp')['y'];
		var z = Array.apply(null, Array(x.length)).map(Number.prototype.valueOf,0);
		
		if (options.getfieldvalue('expdisp')['z']) {
			z = options.getfieldvalue('expdisp')['z'];
		}
		//}}}

		//Compute coordinates and data range: //{{{
		var modelxlim = [ArrayMin(x),ArrayMax(x)];
		var modelylim = [ArrayMin(y),ArrayMax(y)];
		var modelzlim = [ArrayMin(z),ArrayMax(z)];
		var xlim = options.getfieldvalue('xlim',modelxlim);
		var ylim = options.getfieldvalue('ylim',modelylim);
		var zlim = options.getfieldvalue('zlim',modelzlim);
		xmin = xlim[0];
		xmax = xlim[1];
		ymin = ylim[0];
		ymax = ylim[1];
		zmin = zlim[0];
		zmax = zlim[1];
		//}}}

		//Compute scaling: //{{{
		var scale = 1 / (xmax - xmin);
		node['shaderName'] = 'colored';
		node['shader'] = gl['shaders'][node['shaderName']]['program'];
		node['scale'] = [scale, scale, scale*options.getfieldvalue('heightscale',1)];
		node['translation'] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
		node['modelMatrix'] = recalculateModelMatrix(node);
		node['drawMode'] = gl.LINE_LOOP;
		node['drawOrder'] = 0;
		node['useIndexBuffer'] = false;
		node['disableDepthTest'] = true;
		//}}}

		//some defaults:
		colors.itemSize = 4;

		//retrieve some options
		var linewidth=options.getfieldvalue('linewidth',1);
		var edgecolor=options.getfieldvalue('edgecolor','black'); //RGBCOLOR?

		vertices.itemSize = 3;
		for(var i=0; i < x.length; i++){
			vertices[vertices.length] = x[i];
			vertices[vertices.length] = y[i];
			vertices[vertices.length] = z[i];

			//edgecolor
			rgbcolor = [0.0, 0.0, 0.0];
			colors[colors.length] = rgbcolor[0];
			colors[colors.length] = rgbcolor[1];
			colors[colors.length] = rgbcolor[2];
			colors[colors.length] = 1.0;
		}

		//Initalize buffers:
		node['arrays'] = [vertices, colors];
		node['buffers'] = initBuffers(gl, node['arrays']);
	} //}}}
	//cloud of points {{{
	if (options.exist('cloud')) {
		canvas.nodes['cloud'] = Node(gl,options);
		var node = canvas.nodes['cloud'];

		//declare variables:  {{{
		var vertices = [];
		var indices = [];
		var colors = [];
		var rgbcolor = [];
		var xmin,xmax;
		var ymin,ymax;
		var zmin,zmax;
		var scale;
		
		//Process data and model
		var x = options.getfieldvalue('cloud')['x'];
		var y = options.getfieldvalue('cloud')['y'];
		var z = Array.apply(null, Array(x.length)).map(Number.prototype.valueOf,0);
		
		if (options.getfieldvalue('cloud')['z']) {
			z = options.getfieldvalue('cloud')['z'];
		}
		//}}}

		//Compute coordinates and data range: //{{{
		var modelxlim = [ArrayMin(x),ArrayMax(x)];
		var modelylim = [ArrayMin(y),ArrayMax(y)];
		var modelzlim = [ArrayMin(z),ArrayMax(z)];
		var xlim = options.getfieldvalue('xlim',modelxlim);
		var ylim = options.getfieldvalue('ylim',modelylim);
		var zlim = options.getfieldvalue('zlim',modelzlim);
		xmin = xlim[0];
		xmax = xlim[1];
		ymin = ylim[0];
		ymax = ylim[1];
		zmin = zlim[0];
		zmax = zlim[1];
		//}}}

		//Compute scaling: //{{{
		var scale = 1 / (xmax - xmin);
		node['shaderName'] = 'colored';
		node['shader'] = gl['shaders'][node['shaderName']]['program'];
		node['scale'] = [scale, scale, scale*options.getfieldvalue('heightscale',1)];
		node['translation'] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
		node['modelMatrix'] = recalculateModelMatrix(node);
		node['drawMode'] = gl.POINTS;
		node['drawOrder'] = 0;
		node['useIndexBuffer'] = false;
		node['disableDepthTest'] = true;
		//}}}

		//some defaults:
		colors.itemSize = 4;

		//retrieve some options
		var linewidth=options.getfieldvalue('linewidth',1);
		var edgecolor=options.getfieldvalue('edgecolor','black'); //RGBCOLOR?

		vertices.itemSize = 3;
		for(var i=0; i < x.length; i++){
			vertices[vertices.length] = x[i];
			vertices[vertices.length] = y[i];
			vertices[vertices.length] = z[i];

			//edgecolor
			rgbcolor = [0.0, 0.0, 0.0];
			colors[colors.length] = rgbcolor[0];
			colors[colors.length] = rgbcolor[1];
			colors[colors.length] = rgbcolor[2];
			colors[colors.length] = 1.0;
		}

		//Initalize buffers:
		node['arrays'] = [vertices, colors];
		node['buffers'] = initBuffers(gl, node['arrays']);
	} //}}}
	
	//text display //{{{
	if (options.exist('textlabels')) {
		var textcanvas,textcanvasid;	
		textcanvasid = options.getfieldvalue('textcanvasid',options.getfieldvalue('canvasid')+'-text');
		textcanvas = $('#'+textcanvasid);
		textcanvas.textlabels = options.getfieldvalue('textlabels',[]);
		
		//setup drawing function for text canvas draw calls
		textcanvas.draw = function(canvas) {
			var textcontext,textlabels,textlabel,textcanvaswidth,textcanvasheight,textcoordinates;	
			var textposition = vec3.create();
			var mvpMatrix = mat4.create();
			
			//ensure correct canvas coordinate scaling
			textcanvaswidth = this[0].clientWidth;
			textcanvasheight = this[0].clientHeight;
			this[0].width  = textcanvaswidth;
			this[0].height = textcanvasheight;
			
			textcontext = this[0].getContext('2d');
			textlabels = options.getfieldvalue('textlabels',[]);
			textcontext.clearRect(0, 0, textcanvaswidth, textcanvasheight);
			
			//worldspace to screenspace transformation for text
			for (text in textlabels) {
				textlabel = textlabels[text];
				mat4.multiply(mvpMatrix, canvas.cameraMatrix, canvas.nodes['overlay']['modelMatrix']);
				textposition = vec3.transformMat4(textposition, textlabel['pos'], mvpMatrix);
				if (textposition[2] > 1) { //clip coordinates with z > 1
					continue;
				}
				textcoordinates = [(textposition[0]+1.0)/2.0*textcanvaswidth, (-textposition[1]+1.0)/2.0*textcanvasheight]; //NDC to screenspace
				textcontext.font = String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
				textcontext.fillStyle = options.getfieldvalue('colorbarfontcolor','black');
				textcontext.strokeStyle = options.getfieldvalue('colorbarfontcolor','black');
				textcontext.textAlign = 'center';
				textcontext.textBaseline = 'middle';
				textcontext.fillText(textlabel['text'], textcoordinates[0], textcoordinates[1]);
				textcontext.strokeText(textlabel['text'], textcoordinates[0], textcoordinates[1]);
			}
		}
		canvas.textcanvas = textcanvas;
	} //}}}
}
