//FLAIM class definition
//
//   Usage:
//      flaim=new flaim();

function flaim (){
	//methods
	this.setdefaultparameters = function(){// {{{
	}// }}}
	this.disp= function(){// {{{

		console.log(sprintf('   FLAIM - Flight Line Adaptation using Ice sheet Modeling:')); 

		console.log(sprintf('\n      Input:'));
		fielddisplay(this,'targets'            ,'name of kml output targets file ');
		fielddisplay(this,'tracks'             ,'name of kml input tracks file ');
		fielddisplay(this,'flightreqs'         ,'structure of kml flight requirements (not used yet)');
		fielddisplay(this,'criterion'          ,'element or nodal criterion for flight path evaluation (metric)');

		console.log(sprintf('\n      Arguments:'));
		fielddisplay(this,'gridsatequator'     ,'number of grids at equator (determines resolution)');
		fielddisplay(this,'usevalueordering'   ,'flag to consider target values for flight path evaluation');
		fielddisplay(this,'split_antimeridian' ,'flag to split polygons on the antimeridian');

		console.log(sprintf('\n      Optimization:'));
		fielddisplay(this,'path_optimize'     ,'optimize? (default false)');
		fielddisplay(this,'opt_ndir'     ,['number of directions to test when moving a point.  If this value = 1, a random direction is tested.', 'A value > 1 results in directions equally spaced from [0, 2*PI] being tested.', 'For example, 4 would result in directions [0, PI/2, PI, 3PI/2].']);
		fielddisplay(this,'opt_dist'     ,'specifies the distance in km (default 25) to move a randomly selected path point on each iteration');
		fielddisplay(this,'opt_niter'     ,['number of iterations (default 30,000) to run for flightplan optimization', 'i.e. the number of times to randomly select a point and move it.']);

		console.log(sprintf('\n      Output:'));
		fielddisplay(this,'solution'           ,'name of kml solution file');
		fielddisplay(this,'quality'            ,'quality of kml solution');

	}// }}}
	this.checkconsistency = function(md,solution,analyses) { // {{{

		//Early return
		if (solution!=FlaimSolutionEnum()) return;

		checkfield(md,'fieldname','flaim.tracks','file',1);
		if (isNaN(md.flaim.criterion) | md.flaim.criterion.length==0){
			checkfield(md,'fieldname','flaim.targets','file',1);
		}
		else{
			checkfield(md,'fieldname','flaim.criterion','numel',[md.mesh.numberofvertices, md.mesh.numberofelements]);
		}
	} //}}}
	//properties 
	// {{{

	this.targets            = '';
	this.tracks             = '';
	this.flightreqs         = {};
	this.criterion          = NaN;
	this.gridsatequator     = 200000;
	this.usevalueordering   = true;
	this.split_antimeridian = true;
	this.solution           = '';
	this.quality            = 0;
	this.path_optimize      = false;
	this.opt_ndir           = 1;
	this.opt_dist           = 25;
	this.opt_niter          = 30000;

	this.setdefaultparameters();
	//}}}
}
