function slider() {
	//SLIDER - Slider bar with initial value, callback on change, unique name, min/max value range, description message, fill color, widht/height, value precision, value step, and the id of the div to create the slider in.
	//
	//   Usage:
	// 		slider('value',0,'callback',function(value){PlotGreenland(value,0);PlotSlr()},'name','greenland','min',0,'max',100,'message',['Remove ice: ','%'],'color','#BBBBBB','width','100%','height','24px','precision',2,'step',5,'slidersdiv','greenland-sliders');

	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var options = new pairoptions(args.slice());

	//Recover option values:
	var value = options.getfieldvalue('value',0);
	var callback = options.getfieldvalue('callback',function(){});
	var name = options.getfieldvalue('name','');
	var min = options.getfieldvalue('min',0.6*value);
	var max = options.getfieldvalue('max',1.4*value);
	var width = options.getfieldvalue('width','auto');
	var height = options.getfieldvalue('height',32);
	var message = options.getfieldvalue('message','');
	var startmessage = options.getfieldvalue('startmessage',message);
	var middlemessage = options.getfieldvalue('middlemessage',message);
	var endmessage = options.getfieldvalue('endmessage',message);
	var color = options.getfieldvalue('color','#bbbbbb');
	var precision = options.getfieldvalue('precision',3);
	var step = options.getfieldvalue('step',1);
	var slidersdiv = options.getfieldvalue('slidersdiv','slidersdiv');

	$('<div class="'+name+'-slider"></div>').appendTo('#'+slidersdiv);
	$('<div class="info'+name+'">'+startmessage[0]+value.toFixed(precision)+startmessage[1]+'</div>').appendTo('#'+slidersdiv);
	var info=$('.info'+name);
	$('.'+name+'-slider').slider({
		range:'min',
		value:value,
		min:min,
		max:max,
		step:step,
		slide:function(event,ui){
			info.text(middlemessage[0]+ui.value.toFixed(precision)+middlemessage[1]);
		},
		stop:function(event,ui){
			info.text(middlemessage[0]+ui.value.toFixed(precision)+middlemessage[1]);
			callback(ui.value);
			info.text(endmessage[0]+ui.value.toFixed(precision)+endmessage[1]);
		}
	});
	$('.'+name+'-slider.ui-slider').css({
		width:'auto',
		height:height,
		background:color,
		margin:'8px'
	});
	$('.'+name+'-slider .ui-slider-handle').css({
		background:color,
		height:parseInt(height)+8
	});
	$('.'+name+'-slider .ui-slider-range').css({
		background:color
	});
}

function progress() {
	//PROGRESS - Progress bar with initial value, unique name, width/height, and the id of the div to create the slider in. One progress per canvas, value/label updated by node transient runs in plot_unit.
	//
	//   Usage:
	//		progress('value',0,'name','hma','width','100%','height',sliderheight,'progressdiv','hma-progressdiv');
	//
	//   See also: PLOT_UNIT
	
	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var options = new pairoptions(args.slice());
	
	var value = options.getfieldvalue('value',0);
	var name = options.getfieldvalue('name','hma');
	var min = options.getfieldvalue('min',0.6*value);
	var max = options.getfieldvalue('max',1.4*value);
	var width = options.getfieldvalue('width','auto');
	var height = options.getfieldvalue('height',32);
	var color = options.getfieldvalue('color','#bbbbbb');
	var progressdiv = options.getfieldvalue('progressdiv','progressdiv');
	
	var canvas = $('#'+name)[0];
	var progressbar = $('#'+name+'-progressbar');
	var playbutton = $('#'+name+'-playbutton');
	var reversebutton = $('#'+name+'-reversebutton');
	var timelabel = $('#'+name+'-timelabel');

	
	playbutton.click(function() {
		canvas.moviePlay = !canvas.moviePlay;
		if (canvas.moviePlay) {
			$("#playButton").html("&#10074&#10074");
		}
		else {
			$("#playButton").html("&#9654");
		}
	});
	reversebutton.click(function() {
		canvas.movieReverse = !canvas.movieReverse;
		if (canvas.movieReverse) {
			reversebutton.html("&#9664&#9664");
		}
		else {
			reversebutton.html("&#9654&#9654");
		}
	});
	canvas.timeLabel = timelabel;
	
	$('<div class="'+name+'-progressbar bordered margin-8 padding-8"></div>').prependTo('#'+progressdiv);
	$('.'+name+'-progressbar').slider({
		range:'min',
		value:0,
		min:0,
		max:1,
		step:1,
		start:function(event,ui){
			canvas.movieFrame = ui.value;
			canvas.movieIncrement = false;
		},
		slide:function(event,ui){
			canvas.movieFrame = ui.value;
		},
		stop:function(event,ui){
			canvas.movieFrame = ui.value;
			canvas.movieIncrement = true;
		}
	});
	$('.'+name+'-progressbar.ui-slider').css({
		width:'auto',
		height:height,
		background:color,
		margin:'8px'
	});
	$('.'+name+'-progressbar .ui-slider-handle').css({
		background:color,
		height:parseInt(height)+8
	});
	$('.'+name+'-progressbar .ui-slider-range').css({
		background:'red'
	});
	
	canvas.progressBar = $('.'+name+'-progressbar');
}
