step=[4];

if step==1 %Transient Run #1

	md = loadmodel('../Pig/Models/PIG.Control_drag');	

	md.inversion.iscontrol=0;
	md.transient.ismasstransport=1;
	md.transient.isstressbalance=1;
	md.transient.isgroundingline=1;
	md.transient.ismovingfront=0;
	md.transient.isthermal=0;
	
	pos=find(md.mask.groundedice_levelset<0);
	md.basalforcings.groundedice_melting_rate=zeros(md.mesh.numberofvertices,1);
	md.basalforcings.floatingice_melting_rate=25*ones(md.mesh.numberofvertices,1);
	
	md.timestepping.time_step=0.1;
	md.timestepping.final_time=10;
	md.transient.requested_outputs={'default','IceVolume','IceVolumeAboveFloatation'}

	md=solve(md,TransientSolutionEnum);

	% Save model
	save ./Models/PIG.Transient md;
end

if step==2 %High Melt #2
	md = loadmodel('./Models/PIG.Transient');	

	md.basalforcings.groundedice_melting_rate=zeros(md.mesh.numberofvertices,1);
	md.basalforcings.floatingice_melting_rate=60*ones(md.mesh.numberofvertices,1);
	
	md.timestepping.time_step=0.1;
	md.timestepping.final_time=10;
	md.transient.requested_outputs={'default','IceVolume','IceVolumeAboveFloatation'}

	md=solve(md,TransientSolutionEnum);

	save ./Models/PIG.HighMelt md;
end

if step==3 %High surface mass balance #3
	md = loadmodel('./Models/PIG.Transient');	

	md.basalforcings.groundedice_melting_rate=zeros(md.mesh.numberofvertices,1);
	md.basalforcings.floatingice_melting_rate=25*ones(md.mesh.numberofvertices,1);

	md.smb.mass_balance=0*md.smb.mass_balance;
	
	md.timestepping.time_step=0.1;
	md.timestepping.final_time=10;

	md.transient.requested_outputs={'default','IceVolume','IceVolumeAboveFloatation'}

	md=solve(md,TransientSolutionEnum);

	save ./Models/PIG.HighMelt md;
end

if step==4 %Ice Front retreat
	md = loadmodel('./Models/PIG.Transient');	

	md2=extract(md,'FrontRetreat.exp');

	md2=SetMarineIceSheetBC(md2);

	md2.basalforcings.groundedice_melting_rate=zeros(md2.mesh.numberofvertices,1);
	md2.basalforcings.floatingice_melting_rate=25*ones(md2.mesh.numberofvertices,1);

	md2.timestepping.time_step=0.1;
	md2.timestepping.final_time=10;
	md2.transient.requested_outputs={'default','IceVolume','IceVolumeAboveFloatation'}

	md2=solve(md2,TransientSolutionEnum);

	save ./Models/PIG.FrontRetreat md2;
end
