function plotdoc() {
	//PLOTDOC - plot documentation
	//
	//   Usage:
	//      plotdoc()

	//TODO: Update to ensure only options implemented in js are incldued.
	console.log(' WARNING: documentation does not reflect implementation as of June 6 2016');
	console.log('   Plot usage: plotmodel(model,varargin)');
	console.log('   Options: ');
	console.log('       ''figure'': figure number');
	console.log('       ''data'' : what we want to plot');
	console.log('                Available values for ''data'' are: ');
	console.log('                  - any field of the model structure. ex: plot(md,''data'',''vel''), or plot(md,''data'',md.initialization.vel)');
	console.log('                  - ''basal_drag'': plot the basal drag on the bed (in kPa) based on the velocity in md.initialization');
	console.log('                  - ''basal_dragx'' or ''basal_dragy'' : plot a component of the basal drag on the bed (in kPa)');
	console.log('                  - ''boundaries'': this will draw all the segment boundaries to the model, including rifts.');
	console.log('                  - ''icefront'': this will show segments that are used to define the icefront of the model (Neumann boundary conditions).');
	console.log('                  - ''BC'': this will draw all the boundary conditions (Dirichlet and Neumann).');
	console.log('                  - ''deviatoricstress_tensor'': plot the components of the deviatoric stress tensor (tauxx,tauyy,tauzz,tauxy,tauxz,tauyz) if computed');
	console.log('                  - ''deviatoricstress_principal'': plot the deviatoricstress tensor principal axis and principal values');
	console.log('                  - ''deviatoricstress_principalaxis1'': arrow plot the first principal axis of the deviatoricstress tensor(replace 1 by 2 or 3 if needed)');
	console.log('                  - ''driving_stress'': plot the driving stress (in kPa)');
	console.log('                  - ''elements_type'': model used for each element');
	console.log('                  - ''elementnumbering'': numbering of elements');
	console.log('                  - ''vertexnumbering'': numbering of vertices');
	console.log('                  - ''highlightelements'': to highlight elements to highlight the element list');
	console.log('                  - ''highlightvertices'': to highlight vertices (use highlight option to enter the vertex list');
	console.log('                  - ''mesh'': draw mesh using trisurf');
	console.log('                  - ''referential'': stressbalance referential');
	console.log('                  - ''riftvel'': velocities along rifts');
	console.log('                  - ''riftrelvel'': relative velocities along rifts');
	console.log('                  - ''riftpenetration'': penetration levels for a fault');
	console.log('                  - ''riftfraction'': fill fractions for every node of the rifts');
	console.log('                  - ''rifts'': plot mesh with an offset so that rifts are visible');
	console.log('                  - ''strainrate_tensor'': plot the components of the strainrate tensor (exx,eyy,ezz,exy,exz,eyz) if computed');
	console.log('                  - ''strainrate_principal'': plot the strainrate tensor principal axis and principal values)');
	console.log('                  - ''strainrate_principalaxis1'': arrow plot the first principal axis of the strainrate tensor(replace 1 by 2 or 3 if needed)');
	console.log('                  - ''stress_tensor'': plot the components of stress tensor (sxx,syy,szz,sxy,sxz,syz) if computed');
	console.log('                  - ''stress_principal'': plot the stress tensor principal axis and principal values');
	console.log('                  - ''stress_principalaxis1'': arrow plot the first principal axis of the stress tensor(replace 1 by 2 or 3 if needed)');
	console.log('                  - ''transient_results'': this will console.loglay all the time steps of a transient run (use steps to specify the steps requested)');
	console.log('                  - ''transient_vel'': this will console.loglay the velocity for the time steps requested in ''steps'' of a transient run');
	console.log('                  - ''transient_vel'': vel can be by any field of the transient results (vx, vy, vz, vel, temperature, melting, pressure, bed, thickness, surface)');
	console.log('                  - ''transient_field'': dynamic plot of results. specify ''steps'' option, as fell as ''field'' (defaults are all steps, for ''Vel'' field)');
	console.log('                  - ''transient_movie'': this will console.loglay the time steps of a given field of a transient run');
	console.log('                  - ''transient_movie_field'': field to be console.loglayed when doing  transient_movie data console.loglay');
	console.log('                  - ''transient_movie_output'': filename if output is desired for movie');
	console.log('                  - ''transient_movie_time'': time for each image (default 2 seconds)');
	console.log('                  - ''thermaltransient_results'': this will console.loglay all the time steps of a thermal transient run');
	console.log('                  - ''qmuhistnorm'': histogram normal distribution. needs option qmudata');
	console.log('                  - ''qmumean'': plot of mean distribution in sampling analysis with scaled response. needs option qmudata for descriptor');
	console.log('                  - ''qmustddev'': plot of stddev distribution in sampling analysis with scaled response. needs option qmudata for descriptor');
	console.log('                  - ''part_hist'': partitioning node and area histogram');
	console.log('                  - ''quiver'': quiver plot');

	console.log('       ''axis'': same as standard matlab option (''equal'',''off'',''equal on'',...)');
	console.log('       ''basin'': zoom on a given basin (''pineislandglacier'',''ronneiceshelf'', use isbasin to identify a basin');
	console.log('                 ''basindeltax'': in m');
	console.log('                 ''showbasins'': write lables for every existing basin name around the center of the plot');
	console.log('       ''caxis'': modify  colorbar range. (array of type [a b] where b>=a)');
	console.log('       ''backgroundcolor'': plot background color. (default is ''w'')');
	console.log('       ''figurebackgroundcolor'': figure background color. (default is ''none'')');
	console.log('       ''coord'':  ''xy'' (default) or ''latlon''');
	console.log('       ''colorlevels'':  N or {value1,valu2,value3,...} used if quiver, use different colors for the given number of colors or limits');
	console.log('       ''colorbar'': add colorbar (string ''on'' or ''off'')');
	console.log('       ''colorbartitle'': colorbar title (string)');
	console.log('       ''colorbarYlabel'': colorbar Y label (string)');
	console.log('       ''colorbarpos'': [x,y,dx,dy] where x,y,dx and dy are within [0 1]');
	console.log('       ''colorbarcornerposition'': ''West'',''North'',etc ...');
	console.log('       ''colorbartitlerotation'': -90, etc ...');
	console.log('       ''colorbarfontsize'': specify colorbar fontsize');
	console.log('       ''colorbarwidth'': multiplier (default 1) to the default width colorbar');
	console.log('       ''colorbarheight'': multiplier (default 1) to the default height colorbar');
	console.log('       ''colormap'': same as standard matlab option (''jet'',''hsv'',''cool'',''spring'',''gray'',''Ala'',''Rignot'',...)');
	console.log('       ''contourlevels'': N or {value1,valu2,value3,...} add the contours of the specified values or N contours');
	console.log('       ''contourticks'': ''on'' or ''off'' to console.loglay the ticks of the contours');
	console.log('       ''contouronly'': ''on'' or ''off'' to console.loglay the contours on a white background');
	console.log('       ''contourcolor'': ticks and contour color');
	console.log('       ''density'': density of quivers (one arrow every N nodes, N integer)');
	console.log('       ''inset'': add an inset (zoom) of the current figure if 1 (use ''insetx'', ''insety'' and ''insetpos'' to determine the inset position and content)');
	console.log('       ''insetx'': [min(x) max(x)] where min(x) and max(x) are values determining the inset content');
	console.log('       ''insety'': [min(y) max(y)] where min(y) and max(y) are values determining the inset content');
	console.log('       ''insetpos'': [x,y,dx,dy] where x,y,dx and dy are within [0 1]');
	console.log('       ''streamlines'': N (number of stream lines) or {[x1 y1],...} (coordinates of seed points) add streanlines on current figure');
	console.log('       ''edgecolor'': same as standard matlab option EdgeColor (color name: ''black'' or RGB array: [0.5 0.2 0.8])');
	console.log('       ''fontsize'': same as standard matlab option (10,14,...)');
	console.log('       ''fontweight'': same as standard matlab option (normal: ''n'',bold: ''b'',light: ''l'',demi: ''d'')');
	console.log('       ''fontcolor'': same as standard matlab option');
	console.log('       ''highlight'': highlights certain nodes or elements when using ''nodenumbering'' or ''elementnumbering'' or ''highlightnodes '' or ''highlightelements'' option');
	console.log('       ''resolution'': resolution used by section value (array of type [horizontal_resolution vertical_resolution])');
	console.log('                       horizontal_resolution must be in meter, and vertical_resolution a number of layers');
	console.log('       ''showsection'': show section used by ''sectionvalue'' (string ''on'' or a number of labels)');
	console.log('       ''sectionvalue'': give the value of data on a profile given by an Argus file (string ''Argusfile_name.exp'')');
	console.log('       ''profile'': give the value of data along a vertical profile ([xlocation ylocation])');
	console.log('       ''smooth'': smooth element data (string ''yes'' or integer)');
	console.log('       ''title'': same as standard matlab option');
	console.log('       ''view'': same as standard matlab option (ex: 2, 3 or [90 180]');
	console.log('       ''xlim'': same as standard matlab option (ex: [0 500])');
	console.log('       ''ylim'': same as standard matlab option');
	console.log('       ''zlim'': same as standard matlab option');
	console.log('       ''xlabel'': same as standard matlab option (ex:''km'')');
	console.log('       ''ylabel'': same as standard matlab option');
	console.log('       ''xticklabel'': specifiy xticklabel');
	console.log('       ''yticklabel'': specifiy yticklabel');
	console.log('       ''overlay'': yes or no. This will overlay a radar amplitude image behind');
	console.log('       ''overlay_image'': path to overlay image. provide overlay_xlim, overlay_ylim, overlay_xposting and overlay_yposting options also');
	console.log('       ''contrast'': (default 1) coefficient to add contrast to the radar amplitude image used in overlays');
	console.log('       ''highres'': resolution of overlayed radar amplitude image (default is 0, high resolution is 1).');
	console.log('       ''alpha'': transparency coefficient (the higher, the more transparent). Default is 1.5');
	console.log('       ''scaling'': scaling factor used by quiver plots. Default is 0.4');
	console.log('       ''autoscale'': set to ''off'' to have all the quivers with the same size. Default is ''on''');
	console.log('       ''expconsole.log'': plot exp file on top of a data plot. provide exp file as an argument (use a cell of strings if more than one)');
	console.log('       ''expstyle'': marker style for expconsole.log plot (use a cell of strings if more than one)');
	console.log('       ''linewidth'': line width for expconsole.log plot (use a cell of strings if more than one)');
	console.log('       ''border'': size of console.loglay border (in pixels). active only for overlay plots');
	console.log('       ''text'': print string, use a cell of strings if more than one');
	console.log('       ''textposition'': [x y] position of text, use a cell of strings if more than one');
	console.log('       ''textsize'':  same as standard ''FontSize'' matlab option applied to text, use a cell of strings if more than one');
	console.log('       ''textweight'':  same as standard ''FontWeight'' matlab option applied to text, use a cell of strings if more than one');
	console.log('       ''textcolor'':  same as standard ''color'' matlab option applied to text, use a cell of strings if more than one');
	console.log('       ''textrotation'':  same as standard ''Rotation'' matlab option applied to text, use a cell of strings if more than one');
	console.log('       ''mask'': list of flags of size numberofnodes or numberofelements. Only ''true'' values are plotted ');
	console.log('       ''nan'': value assigned to NaNs (convenient when plotting BC)');
	console.log('       ''partitionedges'': ''off'' by default. overlay plot of partition edges');
	console.log('       ''log'': value of log');
	console.log('       ''latlon'': ''on'' or {latstep lonstep [resolution [color]]} where latstep,longstep and resolution are in degrees, color is a [r g b] array');
	console.log('       ''latlonnumbering'': ''on'' or {latgap longap colornumber latangle lonangle} where latgap and longap are pixel gaps for the numbers,'); 
	console.log('       ''latlonclick'': ''on'' to click on latlon ticks positions');
	console.log('                   colornumber is a [r g b] array and latangle and lonangle are angles to flip the numbers');
	console.log('       ''northarrow'': add an arrow pointing north, ''on'' for default value or [x0 y0 length [ratio width fontsize]] where (x0,y0) are the coordinates of the base, ratio=headlength/length');
	console.log('       ''offset'': mesh offset used by ''rifts'', default is 500');
	console.log('       ''scaleruler'': add a scale ruler, ''on'' for default value or [x0 y0 length width numberofticks] where (x0,y0) are the coordinates of the lower left corner');
	console.log('       ''showregion'': show domain in Antarctica on an inset, use ''insetpos'' properties');
	console.log('       ''visible'': ''off'' to make figure unvisible, default is ''on''');
	console.log('       ''wrapping'': repeat ''n'' times the colormap (''n'' must be an integer)');
	console.log('       ''unit'': by default, in m, otherwise, ''km'' is available');
	console.log('       ''legend_position'': by default, ''NorthEasth''');
	console.log('       ''qmudata'': data for qmu  plots.');
	console.log('                  {dresp1   ,dresp2  ,hmin,hmax,hnint} or {samp,desc,mu,sigma,hmin,hmax,hnint}');
	console.log('                  where dresp1 is a structure array of responses (where we need samp and desc), ');
	console.log('                  dresp2 is a structure array of responses (where we only need mu and sigma)');
	console.log('                  hmin,hmax and hnint are the minimum, maximum and number of intervals of the histogram (optional)');
	console.log('       ''figposition'': position of figure: ''fullscreen'', ''halfright'', ''halfleft'', ''portrait'', ''landscape'',... (hardcoded in applyoptions.m)');
	console.log('       ''offsetaxispos'': offset of current axis position to get more space (ex: [-0.02 0  0.04 0])');
	console.log('       ''axispos'': axis position to get more space');
	console.log('       ''hmin'': (numeric, minimum for histogram)');
	console.log('       ''hmax'': (numeric, maximum for histogram)');
	console.log('       ''hnint'': (numeric, number of intervals for histogram)');
	console.log('       ''ymin1'': (numeric, minimum of histogram y-axis)');
	console.log('       ''ymax1'': (numeric, maximum of histogram y-axis)');
	console.log('       ''ymin2'': (numeric, minimum of cdf y-axis)');
	console.log('       ''ymax2'': (numeric, maximum of cdf y-axis)');
	console.log('       ''cdfplt'': (char, ''off'' to turn off cdf line plots)');
	console.log('       ''cdfleg'': (char, ''off'' to turn off cdf legends)');
	console.log('       ''segmentnumbering'': (''off'' by default)');
	console.log('       ''kmlgroundoverlay'': (''off'' by default)');
	console.log('       ''kmlfilename'': (''tempfile.kml'' by default)');
	console.log('       ''kmlroot'': (''./'' by default)');
	console.log('       ''kmlimagename'': (''tempimage'' by default)');
	console.log('       ''kmlimagetype'': (''png'' by default)');
	console.log('       ''kmlresolution'': (1 by default)');
	console.log('       ''kmlfolder'': (''Ground Overlay'' by default)');
	console.log('       ''kmlfolderdescription'': ('''' by default)');
	console.log('       ''kmlgroundoverlayname'': ('''' by default)');
	console.log('       ''kmlgroundoverlaydescription'': ('''' by default)');

	console.log('       any options (except ''data'') can be followed by ''#i'' where ''i'' is the subplot number, or ''#all'' if applied to all plots');
	console.log('  ');
	console.log('   Examples:');
	console.log('       plotmodel(md,''data'',''vel'',''data'',''mesh'',''view#2'',3,''colorbar#all'',''on'',''axis#1'',''off equal'')');
	console.log('       plotmodel(md,''data'',''highlightelements'',''highlight'',[1 4 10],''expconsole.log'',{''domain1.exp'' ''domain2.exp'' ''domain3.exp''})');
}
