#!/bin/bash

#Get number of cpus
NUMCPUS=$1;

#Some cleanup
rm -rf install src

#Create src and install directories
mkdir install src

#version of graphviz
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/graphviz-//g'`
echo $version

#Untar 
tar -zxvf  graphviz-$version.tar.gz

#Move Dakota to src directory
mv graphviz-$version/* src/
rm -rf graphviz-$version

#Configure dakota
cd src
source ../configure.sh
cd ..

#Compile and install
cd install
if [ -z $NUMCPUS ];
then
	make
	make install
else
	make -j $NUMCPUS
	make -j $NUMCPUS install
fi
cd ..
