%MASSCON class definition
%
%   Usage:
%      masscon=masscon();
%      masscon=masscon('name','MassCon58',... %name of a North-East Greenland JPL MassCon
%                    'levelset',level);
% 
%   where level is a levelset vectorial field.
%
%   See also: MISFIT

classdef masscon
	properties (SetAccess=public)
		%masscon
		name              = '';
		definitionenum   = NaN; %enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum
		levelset          = NaN; %levelset vectorial field which identifies the boundaries of the masscon
	end
	
	methods
		function self = masscon(varargin) % {{{
			if nargin==0,
				self=setdefaultparameters(self);
			else
				%use provided options to change fields
				options=pairoptions(varargin{:});

				%get name
				self.name=getfieldvalue(options,'name','');
				self.levelset=getfieldvalue(options,'levelset');
				self.definitionenum=getfieldvalue(options,'definitionenum');

			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ~ischar(self.name),
				error('masscon error message: ''name'' field should be a string!');
			end
			
			md = checkfield(md,'fieldname','self.definitionenum','field',self.definitionenum,'values',[Outputdefinition1Enum:Outputdefinition100Enum]);

			md = checkfield(md,'fieldname','self.levelset','field',self.levelset,'timeseries',1,'NaN',1,'Inf',1);

		end % }}}
		function md = disp(self) % {{{
		
			disp(sprintf('   Misfit:\n'));

			fielddisplay(self,'name','identifier for this masscon response');
			fielddisplay(self,'definitionenum','enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum');
			fielddisplay(self,'levelset','levelset vectorial field which identifies the boundaries of the masscon');

		end % }}}
		function md = marshall(self,prefix,md,fid) % {{{

		WriteData(fid,prefix,'object',self,'fieldname','name','format','String');
		WriteData(fid,prefix,'object',self,'fieldname','definitionenum','format','Integer');
		WriteData(fid,prefix,'object',self,'fieldname','levelset','format','DoubleMat','mattype',1);

		end % }}}
	end
end
