/*!\file DoubleParam.c
 * \brief: implementation of the DoubleParam object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "shared/shared.h"

/*DoubleParam constructors and destructor*/
DoubleParam::DoubleParam(){/*{{{*/
	return;
}
/*}}}*/
DoubleParam::DoubleParam(int in_enum_type,IssmDouble in_value){/*{{{*/

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
DoubleParam::~DoubleParam(){/*{{{*/
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
void DoubleParam::Echo(void){/*{{{*/
	this->DeepEcho();
}
/*}}}*/
void DoubleParam::DeepEcho(void){/*{{{*/

	_printf_(setw(22)<<"   DoubleParam "<<setw(35)<<left<<EnumToStringx(this->enum_type)<<" "<<this->value<<"\n");
}
/*}}}*/
int  DoubleParam::Id(void){ return -1; }/*{{{*/
/*}}}*/
int  DoubleParam::ObjectEnum(void){/*{{{*/

	return DoubleParamEnum;

}
/*}}}*/
Param* DoubleParam::copy() {/*{{{*/

	return new DoubleParam(this->enum_type,this->value);

}
/*}}}*/
void DoubleParam::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ /*{{{*/

	MARSHALLING_ENUM(DoubleParamEnum);

	MARSHALLING(enum_type);
	MARSHALLING(value);

}
/*}}}*/

/*DoubleParam virtual functions definitions: */
void DoubleParam::GetParameterValue(int* pinteger){/*{{{*/
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an integer");
}
/*}}}*/
void DoubleParam::GetParameterValue(bool* pbool){/*{{{*/
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an bool");
}
/*}}}*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM){/*{{{*/
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");
}
/*}}}*/
void DoubleParam::GetParameterValue(int** pintarray,int* pM,int* pN){/*{{{*/
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of integers");
}
/*}}}*/
void DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM){/*{{{*/
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of IssmDouble");
}
/*}}}*/
void DoubleParam::GetParameterValue(IssmDouble** pIssmDoublearray,int* pM,int* pN){/*{{{*/
	_error_("Double param of enum " << enum_type << " (" << EnumToStringx(enum_type) << ") cannot return an array of IssmDouble");
}
/*}}}*/
