function slider(){
	
	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var  options = new pairoptions(args.slice());

	//Recover option values:
	var value = options.getfieldvalue('value',0);
	var callback = options.getfieldvalue('callback',function(){});
	var name = options.getfieldvalue('name','');
	var min = options.getfieldvalue('min',0.6*value);
	var max = options.getfieldvalue('max',1.4*value);
	var width = options.getfieldvalue('width','auto');
	var height = options.getfieldvalue('height',32);
	var message = options.getfieldvalue('message','');
	var startmessage = options.getfieldvalue('startmessage',message);
	var middlemessage = options.getfieldvalue('middlemessage',message);
	var endmessage = options.getfieldvalue('endmessage',message);
	var color = options.getfieldvalue('color','#bbbbbb');
	var precision = options.getfieldvalue('precision',3);
	var step = options.getfieldvalue('step',1);
	var slidersdiv = options.getfieldvalue('slidersdiv','slidersdiv');

	$('#'+slidersdiv).css({width:width});
	$('<div class="'+name+'-slider"></div>').appendTo('#'+slidersdiv);
	$('<div class="info'+name+'">'+startmessage[0]+value.toString()+startmessage[1]+'</div>').appendTo('#'+slidersdiv);
	var info=$('.info'+name);
	$('.'+name+'-slider').slider({
		range:'min',
		value:value,
		min:min,
		max:max,
		step:step,
		slide:function(event,ui){
			moveSlide(event,ui,info,middlemessage,precision);
		},
		stop:function(event,ui){
			stopSlide(event,ui,info,callback,middlemessage,endmessage,precision);
		}
	});
	$('.'+name+'-slider.ui-slider').css({
		width:'auto',
		height:height,
		background:color,
		margin:'8px'
	});
	$('.'+name+'-slider .ui-slider-handle').css({
		background:color,
		height:parseInt(height)+8
	});
	$('.'+name+'-slider .ui-slider-range').css({
		background:color
	});
}

function moveSlide(event,ui,info,middlemessage,precision){
	var val=ui.value;
	info.text(middlemessage[0]+val.toPrecision(precision).toString()+middlemessage[1]);
}

function stopSlide(event,ui,info,functionvalue,middlemessage,endmessage,precision){
	var val=ui.value;
	info.text(middlemessage[0]+val.toPrecision(precision).toString()+middlemessage[1]);
	functionvalue(val);
	info.text(endmessage[0]+val.toPrecision(precision).toString()+endmessage[1]);
}

function progress(){
	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var  options = new pairoptions(args.slice());
	
	var value = options.getfieldvalue('value',0);
	var name = options.getfieldvalue('name','hma');
	var min = options.getfieldvalue('min',0.6*value);
	var max = options.getfieldvalue('max',1.4*value);
	var width = options.getfieldvalue('width','auto');
	var height = options.getfieldvalue('height',32);
	var color = options.getfieldvalue('color','#bbbbbb');
	var progressdiv = options.getfieldvalue('progressdiv','progressdiv');
	
	var canvas = $('#'+name)[0];
	var progressbar = $('#'+name+'-progressbar');
	var playbutton = $('#'+name+'-playbutton');
	var reversebutton = $('#'+name+'-reversebutton');
	var timelabel = $('#'+name+'-timelabel');

	
	playbutton.click(function() {
		canvas.moviePlay = !canvas.moviePlay;
		if (canvas.moviePlay) {
			$("#playButton").html("&#10074&#10074");
		}
		else {
			$("#playButton").html("&#9654");
		}
	});
	reversebutton.click(function() {
		canvas.movieReverse = !canvas.movieReverse;
		if (canvas.movieReverse) {
			reversebutton.html("&#9664&#9664");
		}
		else {
			reversebutton.html("&#9654&#9654");
		}
	});
	canvas.timeLabel = timelabel;
	
	$('#'+progressdiv).css({width:width});
	$('<div class="'+name+'-progressbar bordered margin-8 padding-8"></div>').prependTo('#'+progressdiv);
	$('.'+name+'-progressbar').slider({
		range:'min',
		value:0,
		min:0,
		max:1,
		step:1,
		start:function(event,ui){
			startProgress(event,ui,canvas);
		},
		slide:function(event,ui){
			moveProgress(event,ui,canvas);
		},
		stop:function(event,ui){
			stopProgress(event,ui,canvas);
		}
	});
	$('.'+name+'-progressbar.ui-slider').css({
		width:'auto',
		height:height,
		background:color,
		margin:'8px'
	});
	$('.'+name+'-progressbar .ui-slider-handle').css({
		background:color,
		height:parseInt(height)+8
	});
	$('.'+name+'-progressbar .ui-slider-range').css({
		background:'red'
	});
	
	canvas.progressBar = $('.'+name+'-progressbar');
}

function startProgress(event,ui,canvas){
	canvas.movieFrame = ui.value;
	canvas.movieIncrement = false;
}

function moveProgress(event,ui,canvas){
	canvas.movieFrame = ui.value;
}

function stopProgress(event,ui,canvas){
	canvas.movieFrame = ui.value;
	canvas.movieIncrement = true;
}