//Test Name: SquareShelfConstrainedStressFS
var md = new model();
triangle(md, square[0], 180000.);
setmask(md, 'all', '');
parameterize(md);
md.extrude(md, 3, 2.);
setflowequation(md, 'FS', 'all');
md.cluster = new generic('name', oshostname(), 'np', 3);
md = solve(md, StressbalanceSolutionEnum());

//Fields and tolerances to track changes
var field_names      = ['Vx','Vy','Vz','Vel','Pressure'];
var field_tolerances = [1e-08,1e-08,1e-06,1e-08,1e-08];
var field_values = [
    md.results.StressbalanceSolution.Vx,
    md.results.StressbalanceSolution.Vy,
    md.results.StressbalanceSolution.Vz,
    md.results.StressbalanceSolution.Vel,
    md.results.StressbalanceSolution.Pressure
];
