function [xout,yout] = gdaltransform(x,y,proj_in,proj_out)
%GDALTRANSFORM - switch from one projection system to another 
%
%   Usage:
%      [x,y] = gdaltransform(x1,y1,epsg_in, epsg_out);
%
%   Example: 
%      [x,y] = gdaltransform(md.mesh.lat,md.mesh.long,'EPSG:3184','EPSG:3411'); 
%
%   For reference: 
%       EPSG: 4326 (lat,long)
%       EPSG: 3411  (greenland, +proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs)
%       EPSG: 3031 (antarctica, +proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs)

	%give ourselves a unique temporary directory: 
	temproot=tempname; mkdir(temproot);

	fid=fopen([temproot '/.rand1234.txt'],'w');
	for i=1:length(x),
		fprintf(fid,'%g %g\n',x(i),y(i));
	end
	fclose(fid);

	[s,r]=system(['gdaltransform -s_srs ',proj_in,' -t_srs ',proj_out,'  < ' temproot '/.rand1234.txt > ' temproot '/.rand1235.txt']);
	if s~=0 | ~isempty(deblank(r)),
		error(r);
	end
	A=textread([temproot '/.rand1235.txt']);
	xout=A(:,1);
	yout=A(:,2);
