function applyoptions(md,data,options,canvas,gl,node){
	//APPLYOPTIONS - apply the options to current plot
	//
	//   Usage:
	//      applyoptions(md,data,options)
	//
	//   See also: PLOTMODEL, PARSE_OPTIONS
	
	//colorbar {{{
	if (options.exist('colorbar')) {
		if (options.getfieldvalue('colorbar')==1) {
			//Handle movie data {{{
				if (typeof data == 'string') {
				//throw Error('plot error message: data of type string');
				return;
			}
			var	dataresults = processdata(md,data,options);
			var	data2 = dataresults[0]; 
			var	datatype = dataresults[1];
			if (datatype == 5) {
				//Transpose data to obtain column addressable data matrix
				data = data[0].map(function(col, i) { 
					return data.map(function(row) { 
						return row[i]
					})
				});
				data = data[0].slice(0,-1);
			} //}}}
			//Variable options initialization {{{
			
			var caxis = options.getfieldvalue('caxis',[ArrayMin(data),ArrayMax(data)]);
			var canvassize = options.getfieldvalue('canvassize',480);
			var cheight;
			var cwidth;
			var cdivisions = cheight/4;
			var color;
			var ccontext,ccanvas,ccanvasid,ccanvashtml;
			var colorbarorientiation = options.getfieldvalue('colorbarorientation','vertical');
			var cheightoffset = options.getfieldvalue('colorbarfontsize',18);
			var cwidthoffset = options.getfieldvalue('colorbarfontsize',18)*3;
			var y;
			var x;
			//}}}
			//Set colorbar lables {{{
			var labels = [];
			var cdivisions = options.getfieldvalue('colorbarnticks',6);
			var caxisdelta = caxis[1] - caxis[0];
			var clabelitem;
			var precision=options.getfieldvalue('colorbarprecision',3);
			if (options.getfieldvalue('log',10)!='off') {
				for (var i = cdivisions; i >= 0; i--) {
					if (caxisdelta*i/cdivisions==caxis[0]) {
						labels[i] = (caxis[0]).toPrecision(precision);
					}
					else {
						labels[i] = (Math.exp(Math.log(caxisdelta)*(cdivisions-i)/cdivisions)+caxis[0]).toPrecision(precision);
					}
				}
			} else {
				for (var i = cdivisions; i >= 0; i--) {
					labels[i] = (caxisdelta*(cdivisions-i)/cdivisions+caxis[0]).toPrecision(precision);
				}
			} //}}}
			//Handle orientation {{{
			if (colorbarorientiation=='vertical') { //{{{
				cheight = options.getfieldvalue('colorbarheight',0.95)*canvassize;
				cwidth = options.getfieldvalue('colorbarwidth',canvassize/20);
				ccanvasid = options.getfieldvalue('colorbarcanvasid',options.getfieldvalue('canvasid')+'_colorbar');
				ccanvashtml = document.getElementById(ccanvasid);
				if (ccanvashtml==null) {
					ccanvas = $('<canvas id="'+ccanvasid+'" width="'+String(cwidth+cheightoffset*4)+'" height="'+String(cheight+cheightoffset*2)+'"></canvas>').insertAfter('#'+options.getfieldvalue('canvasid'));
					ccanvas.css({'position':'relative','top':((canvassize-cheight-cheightoffset)/-2).toFixed(2)+'px'});
					ccontext = ccanvas[0].getContext('2d');
				}
				else{
					ccanvas = $('#'+ccanvasid);
					if (options.exist('colorbarcanvasid')&&!ccanvashtml.hasOwnProperty('init')){
						//store actual colobar size
						cwidth = ccanvashtml.clientWidth;
						cheight = ccanvashtml.clientHeight;
						ccanvas.attr({width:cwidth+cheightoffset*4,height:cheight+cheightoffset*2}).css({width:cwidth+cheightoffset*4,height:cheight+cheightoffset*2});
						//get html object instead of jqurey object to modify height/width to accomodate labels
						ccanvashtml.cwidth = cwidth;
						ccanvashtml.cheight = cheight;
						ccanvashtml.init = true;
					}
					else {
						cwidth = ccanvashtml.cwidth;
						cheight = ccanvashtml.cheight;
					}
					ccontext = ccanvas[0].getContext('2d');
					/*erase existing colorbar:*/
					ccontext.clearRect(0,0, ccanvashtml.width, ccanvashtml.height);
					ccontext.beginPath();
				}
				var cgradient = ccontext.createLinearGradient(0,cheightoffset/2,0,cheight);
				
				var cmap = options.getfieldvalue('cmap','jet');
				var colorbar = colorbars[cmap];
				for (var i = 0; i < colorbar.length; i++) {
					color = colorbar[colorbar.length-i-1];
					color = [Math.round(color[0]*255),Math.round(color[1]*255),Math.round(color[2]*255)];	
					cgradient.addColorStop(i/colorbar.length,'rgba('+color.toString()+',1.0)');
				}
				ccontext.fillStyle=cgradient;
				ccontext.fillRect(0,cheightoffset*3/2,cwidth,cheight);
				
				//Draw colorbar border
				ccontext.beginPath();
				ccontext.lineWidth='1';
				ccontext.strokeStyle='black';
				ccontext.rect(0,cheightoffset*3/2,cwidth,cheight);
				ccontext.stroke();
				
				for (var i = 0; i <= cdivisions; i++) {
					y = i/cdivisions*cheight+cheightoffset/2;
					x = 0.2*cwidth;
					ccontext.beginPath();
					ccontext.moveTo(0,y+cheightoffset);
					ccontext.lineTo(x,y+cheightoffset);
					ccontext.moveTo(cwidth-x,y+cheightoffset);
					ccontext.lineTo(cwidth,y+cheightoffset);
					ccontext.stroke();
					ccontext.font=String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
					ccontext.fillStyle='black';
					ccontext.textAlign='left';
					ccontext.fillText(labels[i],cwidth+x,y+cheightoffset*3/2);
				}
				if (options.exist('colorbartitle')) {
					ccontext.font=String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
					ccontext.fillStyle='black';
					ccontext.textAlign='left';
					ccontext.textBaseline='bottom';
					ccontext.fillText(options.getfieldvalue('colorbartitle'),0,cheightoffset);
				}
			} //}}}
			else { //colorbarorientiation=='horizontal' {{{
				cheight = options.getfieldvalue('colorbarheight',canvassize/20);
				cwidth = options.getfieldvalue('colorbarwidth',0.95)*canvassize;
				ccanvasid = options.getfieldvalue('colorbarcanvasid',options.getfieldvalue('canvasid')+'_colorbar');
				ccanvashtml = document.getElementById(ccanvasid);
				if (ccanvashtml==null) {
					ccanvas = $('<canvas id="'+ccanvasid+'" width="'+String(cwidth+cheightoffset*4)+'" height="'+String(cheight+cheightoffset*5/2)+'"></canvas>').insertAfter('#'+options.getfieldvalue('canvasid'));
					ccanvas.css({'position':'relative','top':((canvassize-cheight-cheightoffset*2)/-2).toFixed(2)+'px'});
					ccontext = ccanvas[0].getContext('2d');
				}
				else{
					ccanvas = $('#'+ccanvasid);
					if (options.exist('colorbarcanvasid')&&!ccanvashtml.hasOwnProperty('init')){
						//store actual colobar size
						cwidth = ccanvashtml.clientWidth;
						cheight = ccanvashtml.clientHeight;
						//get html object instead of jqurey object to modify height/width to accomodate labels
						ccanvashtml.width = cwidth+cheightoffset*6;
						ccanvashtml.height = cheight+cheightoffset*5/2;
						ccanvashtml.cwidth = cwidth;
						ccanvashtml.cheight = cheight;
						ccanvashtml.init = true;
					}
					else {
						cwidth = ccanvashtml.cwidth;
						cheight = ccanvashtml.cheight;
					}
					ccontext = ccanvas[0].getContext('2d');
					/*erase existing colorbar:*/
					ccontext.clearRect(0,0, ccanvashtml.width, ccanvashtml.height);
					ccontext.beginPath();
				}
				var cgradient = ccontext.createLinearGradient(cwidth+cwidthoffset,0,cwidthoffset,0);
				
				var cmap = options.getfieldvalue('cmap','jet');
				var colorbar = colorbars[cmap];
				for (var i = 0; i < colorbar.length; i++) {
					color = colorbar[colorbar.length-i-1];
					color = [Math.round(color[0]*255),Math.round(color[1]*255),Math.round(color[2]*255)];	
					cgradient.addColorStop(i/colorbar.length,'rgba('+color.toString()+',1.0)');
				}
				ccontext.fillStyle=cgradient;
				ccontext.fillRect(cwidthoffset,cheightoffset,cwidth,cheight);
				
				//Draw colorbar border
				ccontext.beginPath();
				ccontext.lineWidth='1';
				ccontext.strokeStyle='black';
				ccontext.rect(cwidthoffset,cheightoffset,cwidth,cheight);
				ccontext.stroke();
				
				for (var i = 0; i <= cdivisions; i++) {
					y = 0.2*cheight;
					x = i/cdivisions*cwidth;
					ccontext.beginPath();
					ccontext.moveTo(x+cwidthoffset,cheightoffset);
					ccontext.lineTo(x+cwidthoffset,y+cheightoffset);
					ccontext.moveTo(x+cwidthoffset,cheight-y+cheightoffset);
					ccontext.lineTo(x+cwidthoffset,cheight+cheightoffset);
					ccontext.stroke();
					ccontext.font=String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
					ccontext.fillStyle='black';
					ccontext.textAlign='center';
					ccontext.fillText(labels[cdivisions-i],x+cwidthoffset,cheight+cheightoffset*2);
				}
				if (options.exist('colorbartitle')) {
					ccontext.font=String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
					ccontext.fillStyle='black';
					ccontext.textAlign='center';
					ccontext.textBaseline='bottom';
					ccontext.fillText(options.getfieldvalue('colorbartitle'),cwidth/2+cwidthoffset,cheightoffset);
				}
			} //}}}
			//}}}
		} 
	}
	//}}}
	//texture canvas //{{{
	var tcontext,tcanvas,tcanvasid,tcanvashtml,tURL,tgradient;
	tcanvasid = 'texturecanvas';
	var tcanvashtml = document.getElementById(tcanvasid);
	if (tcanvashtml == null) {
		tcanvas = $('<canvas id="texturecanvas" width="256" height="256"></canvas>').insertAfter('#'+String(options.getfieldvalue('canvasid')));
		tcanvas.css({'display':'none'});
		tcanvashtml = document.getElementById(tcanvasid);
	}
	else {
		tcanvas = $('#' + tcanvasid);
	}
	tcontext = tcanvashtml.getContext('2d');
	tgradient = tcontext.createLinearGradient(0,0,0,256);
		
	var cmap = options.getfieldvalue('cmap','jet');
	var colorbar = colorbars[cmap];
	if (options.getfieldvalue('log',10)!='off') {
		for (var i = 0; i < colorbar.length; i++) {
			color = colorbar[colorbar.length-i-1];
			color = [Math.round(color[0]*255),Math.round(color[1]*255),Math.round(color[2]*255)];	
			tgradient.addColorStop(1.0-Math.exp(Math.log((colorbar.length-i)/colorbar.length)/Math.log(options.getfieldvalue('log',10))*i/colorbar.length),'rgba('+color.toString()+',1.0)');
		}
	} else {
		for (var i = 0; i < colorbar.length; i++) {
			color = colorbar[colorbar.length-i-1];
			color = [Math.round(color[0]*255),Math.round(color[1]*255),Math.round(color[2]*255)];	
			tgradient.addColorStop(i/colorbar.length,'rgba('+color.toString()+',1.0)');
		}
	}
	
	tcontext.fillStyle = tgradient;
	tcontext.fillRect(0,0,256,256);
	tURL = tcanvashtml.toDataURL();
	node['texture'] = initTexture(gl,tURL);
	//}}}
	//expdisp contours {{{
	if (options.exist('expdisp')) {
		canvas.nodes['expdisp'] = Node(gl,options);
		var node = canvas.nodes['expdisp'];
		
		//declare variables:  {{{
		var vertices = [];
		var indices = [];
		var colors = [];
		var rgbcolor = [];
		var xmin,xmax;
		var ymin,ymax;
		var zmin,zmax;
		var scale;
		
		//Process data and model
		var x = options.getfieldvalue('expdisp')['x'];
		var y = options.getfieldvalue('expdisp')['y'];
		var z = Array.apply(null, Array(x.length)).map(Number.prototype.valueOf,0);
		
		if (options.getfieldvalue('expdisp')['z']) {
			z = options.getfieldvalue('expdisp')['z'];
		}
		//}}}

		//Compute coordinates and data range: //{{{
		var modelxlim = [ArrayMin(x),ArrayMax(x)];
		var modelylim = [ArrayMin(y),ArrayMax(y)];
		var modelzlim = [ArrayMin(z),ArrayMax(z)];
		var xlim = options.getfieldvalue('xlim',modelxlim);
		var ylim = options.getfieldvalue('ylim',modelylim);
		var zlim = options.getfieldvalue('zlim',modelzlim);
		xmin = xlim[0];
		xmax = xlim[1];
		ymin = ylim[0];
		ymax = ylim[1];
		zmin = zlim[0];
		zmax = zlim[1];
		//}}}

		//Compute scaling: //{{{
		var scale = 1 / (xmax - xmin);
		node['shaderName'] = 'colored';
		node['shader'] = gl['shaders'][node['shaderName']]['program'];
		node['scale'] = [scale, scale, scale*options.getfieldvalue('heightscale',1)];
		node['translation'] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
		node['modelMatrix'] = recalculateModelMatrix(node);
		node['drawMode'] = gl.LINE_LOOP;
		node['drawOrder'] = 0;
		node['useIndexBuffer'] = false;
		node['disableDepthTest'] = true;
		//}}}

		//some defaults:
		colors.itemSize = 4;

		//retrieve some options
		var linewidth=options.getfieldvalue('linewidth',1);
		var edgecolor=options.getfieldvalue('edgecolor','black'); //RGBCOLOR?

		vertices.itemSize = 3;
		for(var i = 0; i < x.length; i++){
			vertices[vertices.length] = x[i];
			vertices[vertices.length] = y[i];
			vertices[vertices.length] = z[i];

			//edgecolor
			rgbcolor = [0.0, 0.0, 0.0];
			colors[colors.length] = rgbcolor[0];
			colors[colors.length] = rgbcolor[1];
			colors[colors.length] = rgbcolor[2];
			colors[colors.length] = 1.0;
		}

		//Initalize buffers:
		node['arrays'] = [vertices, colors];
		node['buffers'] = initBuffers(gl, node['arrays']);
	} //}}}
	//cloud of points {{{
	if (options.exist('cloud')) {
		canvas.nodes['cloud'] = Node(gl,options);
		var node = canvas.nodes['cloud'];

		//declare variables:  {{{
		var vertices = [];
		var indices = [];
		var colors = [];
		var rgbcolor = [];
		var xmin,xmax;
		var ymin,ymax;
		var zmin,zmax;
		var scale;
		
		//Process data and model
		var x = options.getfieldvalue('cloud')['x'];
		var y = options.getfieldvalue('cloud')['y'];
		var z = Array.apply(null, Array(x.length)).map(Number.prototype.valueOf,0);
		
		if (options.getfieldvalue('cloud')['z']) {
			z = options.getfieldvalue('cloud')['z'];
		}
		//}}}

		//Compute coordinates and data range: //{{{
		var modelxlim = [ArrayMin(x),ArrayMax(x)];
		var modelylim = [ArrayMin(y),ArrayMax(y)];
		var modelzlim = [ArrayMin(z),ArrayMax(z)];
		var xlim = options.getfieldvalue('xlim',modelxlim);
		var ylim = options.getfieldvalue('ylim',modelylim);
		var zlim = options.getfieldvalue('zlim',modelzlim);
		xmin = xlim[0];
		xmax = xlim[1];
		ymin = ylim[0];
		ymax = ylim[1];
		zmin = zlim[0];
		zmax = zlim[1];
		//}}}

		//Compute scaling: //{{{
		var scale = 1 / (xmax - xmin);
		node['shaderName'] = 'colored';
		node['shader'] = gl['shaders'][node['shaderName']]['program'];
		node['scale'] = [scale, scale, scale*options.getfieldvalue('heightscale',1)];
		node['translation'] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
		node['modelMatrix'] = recalculateModelMatrix(node);
		node['drawMode'] = gl.POINTS;
		node['drawOrder'] = 0;
		node['useIndexBuffer'] = false;
		node['disableDepthTest'] = true;
		//}}}

		//some defaults:
		colors.itemSize = 4;

		//retrieve some options
		var linewidth=options.getfieldvalue('linewidth',1);
		var edgecolor=options.getfieldvalue('edgecolor','black'); //RGBCOLOR?

		vertices.itemSize = 3;
		for(var i = 0; i < x.length; i++){
			vertices[vertices.length] = x[i];
			vertices[vertices.length] = y[i];
			vertices[vertices.length] = z[i];

			//edgecolor
			rgbcolor = [0.0, 0.0, 0.0];
			colors[colors.length] = rgbcolor[0];
			colors[colors.length] = rgbcolor[1];
			colors[colors.length] = rgbcolor[2];
			colors[colors.length] = 1.0;
		}

		//Initalize buffers:
		node['arrays'] = [vertices, colors];
		node['buffers'] = initBuffers(gl, node['arrays']);
	} //}}}
	
	//text display //{{{
	if (options.exist('textlabels')) {
		var textcanvas,textcanvasid;	
		textcanvasid = options.getfieldvalue('textcanvasid',options.getfieldvalue('canvasid')+'-text');
		textcanvas = $('#'+textcanvasid);
		textcanvas.textlabels = options.getfieldvalue('textlabels',[]);
		
		//setup drawing function for text canvas draw calls
		textcanvas.draw = function(canvas) {
			var textcontext,textlabels,textlabel,textcanvaswidth,textcanvasheight,textcoordinates;	
			var textposition = vec3.create();
			var mvpMatrix = mat4.create();
			
			//ensure correct canvas coordinate scaling
			textcanvaswidth = this[0].clientWidth;
			textcanvasheight = this[0].clientHeight;
			this[0].width  = textcanvaswidth;
			this[0].height = textcanvasheight;
			
			textcontext = this[0].getContext('2d');
			textlabels = options.getfieldvalue('textlabels',[]);
			textcontext.clearRect(0, 0, textcanvaswidth, textcanvasheight);
			
			//worldspace to screenspace transformation for text
			for (text in textlabels) {
				textlabel = textlabels[text];
				mat4.multiply(mvpMatrix, canvas.cameraMatrix, canvas.nodes['overlay']['modelMatrix']);
				textposition = vec3.transformMat4(textposition, textlabel['pos'], mvpMatrix);
				if (textposition[2] > 1) { //clip coordinates with z > 1
					continue;
				}
				textcoordinates = [(textposition[0]+1.0)/2.0*textcanvaswidth, (-textposition[1]+1.0)/2.0*textcanvasheight]; //NDC to screenspace
				textcontext.font = String(options.getfieldvalue('colorbarfontsize',18))+'px "Lato",Helvetica,Arial,sans-serif';
				textcontext.fillStyle = 'black';
				textcontext.strokeStyle = 'black';
				textcontext.textAlign = 'center';
				textcontext.textBaseline = 'middle';
				textcontext.fillText(textlabel['text'], textcoordinates[0], textcoordinates[1]);
				textcontext.strokeText(textlabel['text'], textcoordinates[0], textcoordinates[1]);
			}
		}
		canvas.textcanvas = textcanvas;
	} //}}}
}