%Test Name: SquareShelfTranSSA2dMismipFloatingMeltParam
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);
md.basalforcings=mismipbasalforcings(md.basalforcings);
md.transient.isgroundingline=1;
md.geometry.bed=min(md.geometry.base)*ones(md.mesh.numberofvertices,1);
md.transient.requested_outputs={'default','BasalforcingsFloatingiceMeltingRate'};
md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','BasalforcingsFloatingiceMeltingRate1',...
	'Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','BasalforcingsFloatingiceMeltingRate2',...
	'Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3','BasalforcingsFloatingiceMeltingRate3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).BasalforcingsFloatingiceMeltingRate),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).BasalforcingsFloatingiceMeltingRate),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Pressure),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).BasalforcingsFloatingiceMeltingRate),...
	};
