#Test Name: SquareShelfConstrainedRestartTranHO3d
from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *
from massfluxatgate import massfluxatgate
from generic import generic
import copy

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md.cluster=generic('name',oshostname(),'np',1)
md.transient.requested_outputs=['IceVolume','TotalSmb']
md.extrude(3,1.)
md=setflowequation(md,'HO','all')

md.verbose=verbose('solution',1);
md.settings.recording_frequency=5

# time steps and resolution
md.timestepping.final_time=8

md=solve(md,TransientSolutionEnum())
md2=copy.deepcopy(md)
md=solve(md,TransientSolutionEnum(),'restart',1)

#Fields and tolerances to track changes
field_names     =['Vx1','Vy1','Vel1','TotalSmb1','Bed1','Surface1','Thickness1','Volume1','Temperature1','Pressure1','Vx2','Vy2','Vel2','TotalSmb2','Bed2','Surface2','Thickness2','Volume2','Temperature2','Pressure2','Vx3','Vy3','Vel3','TotalSmb3','Bed3','Surface3','Thickness3','Volume3','Temperature3','Pressure3'];
field_tolerances=[1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,\
		1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,\
		1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,\
		1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,\
		1e-13,1e-13,1e-13,1e-13,1e-13,1e-13]
field_values=[\
		md2.results.TransientSolution[5].Vx-md.results.TransientSolution[0].Vx,\
		md2.results.TransientSolution[5].Vy-md.results.TransientSolution[0].Vy,\
		md2.results.TransientSolution[5].Vel-md.results.TransientSolution[0].Vel,\
		md2.results.TransientSolution[5].TotalSmb-md.results.TransientSolution[0].TotalSmb,\
		md2.results.TransientSolution[5].Base-md.results.TransientSolution[0].Base,\
		md2.results.TransientSolution[5].Surface-md.results.TransientSolution[0].Surface,\
		md2.results.TransientSolution[5].Thickness-md.results.TransientSolution[0].Thickness,\
		md2.results.TransientSolution[5].IceVolume-md.results.TransientSolution[0].IceVolume,\
		md2.results.TransientSolution[5].Temperature-md.results.TransientSolution[0].Temperature,\
		md2.results.TransientSolution[5].Pressure-md.results.TransientSolution[0].Pressure,\
		md2.results.TransientSolution[6].Vx-md.results.TransientSolution[1].Vx,\
		md2.results.TransientSolution[6].Vy-md.results.TransientSolution[1].Vy,\
		md2.results.TransientSolution[6].Vel-md.results.TransientSolution[1].Vel,\
		md2.results.TransientSolution[6].TotalSmb-md.results.TransientSolution[1].TotalSmb,\
		md2.results.TransientSolution[6].Base-md.results.TransientSolution[1].Base,\
		md2.results.TransientSolution[6].Surface-md.results.TransientSolution[1].Surface,\
		md2.results.TransientSolution[6].Thickness-md.results.TransientSolution[1].Thickness,\
		md2.results.TransientSolution[6].IceVolume-md.results.TransientSolution[1].IceVolume,\
		md2.results.TransientSolution[6].Temperature-md.results.TransientSolution[1].Temperature,\
		md2.results.TransientSolution[6].Pressure-md.results.TransientSolution[1].Pressure,\
		md2.results.TransientSolution[7].Vx-md.results.TransientSolution[2].Vx,\
		md2.results.TransientSolution[7].Vy-md.results.TransientSolution[2].Vy,\
		md2.results.TransientSolution[7].Vel-md.results.TransientSolution[2].Vel,\
		md2.results.TransientSolution[7].TotalSmb-md.results.TransientSolution[2].TotalSmb,\
		md2.results.TransientSolution[7].Base-md.results.TransientSolution[2].Base,\
		md2.results.TransientSolution[7].Surface-md.results.TransientSolution[2].Surface,\
		md2.results.TransientSolution[7].Thickness-md.results.TransientSolution[2].Thickness,\
		md2.results.TransientSolution[7].IceVolume-md.results.TransientSolution[2].IceVolume,\
		md2.results.TransientSolution[7].Temperature-md.results.TransientSolution[2].Temperature,\
		md2.results.TransientSolution[7].Pressure-md.results.TransientSolution[2].Pressure\
		]

