function marshall(md){
//MARSHALL - outputs a typed array buffer to be send to the issm module.
//
//   The routine creates a compatible binary stream from @model md
//   This binary stream will be used for single cpu runs using the issm module.
//
//   Usage:
//      fid=marshall(md)

	if (md.verbose.solution){
		console.log('marshalling file ' + md.miscellaneous.name + '.bin');
	}

	//open file for binary writing
	var fid=new fileptr('mode','w');

	//First, write MaximumNumberOfEnum to make sure that the Enums are synchronized
	WriteData(fid,'enum',MaximumNumberOfDefinitionsEnum(),'data',true,'format','Boolean');

	//Go through all model fields: check that it is a class and call checkconsistency
	for (field in md){

		//Some properties do not need to be marshalled
		if (field == 'results' | field =='radaroverlay' | field == 'toolkits' | field =='cluster' | field == 'flaim' | field == 'priv') continue;
		
		//Check that current field is a class
		if(typeof md[field] == 'function'){
			continue;
		}

		//Marshall current object
		md[field].marshall(md,fid);
	}

	//Last, write MaximumNumberOfEnum+1 to make sure that the binary file is not corrupt
	WriteData(fid,'enum',MaximumNumberOfDefinitionsEnum()+1,'data',true,'format','Boolean');
	return fid;
}
