function plotgemb(results,fieldname,varargin);

	options=pairoptions(varargin{:});

	zerolevel= getfieldvalue(options,'zerolevel',0);
	numlevels= getfieldvalue(options,'numlevels',-1);
	element= getfieldvalue(options,'element',1);
	maxstep=getfieldvalue(options,'maxstep',length(results));

	%number of results: 
	nt=length(results); 

	for i=1:nt, 

		z0=zerolevel;

		%retrieve time, and delta around time: 
		time=results(i).time;
		if i<nt,
			deltat=results(i+1).time-time;
		else
			deltat=time-results(i-1).time;
		end

		%figure out number of levels: 
		dz=flipud(results(i).SmbDz(element,:)') ;
		if numlevels==-1,
			nlevels=length(dz); 
		else
			nlevels=numlevels;
		end
		dz=dz(1:nlevels);

		%retrieve values: 
		field=results(i).(fieldname);
		T=flipud(field(element,1:nlevels)');

		%build vertical values: 
		nz=length(dz); 
		for j=1:nz, 
			patch([time-deltat/2 ;time+deltat/2; time+deltat/2; time-deltat/2],[z0; z0; z0+dz(j); z0+dz(j)],[T(j);T(j);T(j);T(j)]);
			z0=z0+dz(j);
		end
		if i>=maxstep,
			break;
		end
	end
