function plot_BC(md,options,width,i,data)

%plot neuman
h0 = plot_icefront(md,options,width,i,data);

hold on

[x y z elements is2d isplanet]=processmesh(md,[],options);

%plot dirichlets
dirichleton=getfieldvalue(options,'dirichlet','on');
if strcmpi(dirichleton,'on'),
	h1=plot3(...
		x(find(~isnan(md.stressbalance.spcvx(1:md.mesh.numberofvertices,1)))),...
		y(find(~isnan(md.stressbalance.spcvx(1:md.mesh.numberofvertices,1)))),...
		z(find(~isnan(md.stressbalance.spcvx(1:md.mesh.numberofvertices,1)))),...
		'ro','MarkerSize',14,'MarkerFaceColor','r');
	h2=plot3(...
		x(find(~isnan(md.stressbalance.spcvy(1:md.mesh.numberofvertices,1)))),...
		y(find(~isnan(md.stressbalance.spcvy(1:md.mesh.numberofvertices,1)))),...
		z(find(~isnan(md.stressbalance.spcvy(1:md.mesh.numberofvertices,1)))),...
		'bo','MarkerSize',10,'MarkerFaceColor','b');
	h3=plot3(...
		x(find(~isnan(md.stressbalance.spcvz(1:md.mesh.numberofvertices,1)))),...
		y(find(~isnan(md.stressbalance.spcvz(1:md.mesh.numberofvertices,1)))),...
		z(find(~isnan(md.stressbalance.spcvz(1:md.mesh.numberofvertices,1)))),...
		'yo','MarkerSize',6 ,'MarkerFaceColor','y');
end

strings = {'Neumann'};
if ~isempty(h1), strings{end+1} = 'vx Dirichlet'; end
if ~isempty(h2), strings{end+1} = 'vy Dirichlet'; end
if ~isempty(h3), strings{end+1} = 'vz Dirichlet'; end

legend([h0,h1,h2,h3],strings,'location','NorthEast');

hold off

%apply options
options=addfielddefault(options,'title','Boundary conditions');
options=addfielddefault(options,'colorbar',0);
applyoptions(md,[],options);
