function gauge(){
	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var options = new pairoptions(args);

	gaugecanvas=options.getfieldvalue('gaugecanvas','gauge');
	gaugetext=options.getfieldvalue('gaugetext','gauge-text');
	gaugediv=options.getfieldvalue('gaugediv','slr-controldiv');
	gaugevalue=options.getfieldvalue('value',0);
	min=options.getfieldvalue('min',0);
	max=options.getfieldvalue('max',22);
	colors=options.getfieldvalue('colors',[[0.0, "#000000" ], [0.50, "#880000"], [1.0, "#ff0000"]]);
	label=options.getfieldvalue('label','');
	
	$('<canvas id="'+gaugecanvas+'" width=80px height=50%></canvas>').appendTo('#'+gaugediv);
	$('<div id="'+gaugetext+'" class="gaugetext"></div>').appendTo('#'+gaugediv);
	
	var opts = {
		lines: 12, // The number of lines to draw
		angle: 0, // The length of each line
		lineWidth: 0.38, // The line thickness
		pointer: {
			length: 0, // The radius of the inner circle
			strokeWidth: 0, // The rotation offset
			color: '#000000' // Fill color
		},
		limitMax: 'false',   // If true, the pointer will not go past the end of the gauge
		colorStart: '#6F6EA0',   // Colors
		colorStop: '#C0C0DB',    // just experiment with them
		strokeColor: '#EEEEEE',   // to see which ones work best for you
		percentColors: colors,
		generateGradient: true
	};
	var target = document.getElementById(gaugecanvas)
	var gauge = new Gauge(target).setOptions(opts);
	gauge.setTextField(document.getElementById(gaugetext));
	gauge.label = label;
	gauge.textField.render = function(gauge) {
      return this.el.innerHTML = gauge.displayedValue.toFixed(0) + ' ' + gauge.label;
    };
	gauge.minValue = min;
	gauge.maxValue = max;
	gauge.animationSpeed = 1;
	gauge.set(1); // set once to initialize?
	gauge.set(gaugevalue); // set actual value
	
	return gauge;
}
