/*!\file fx.cpp
 * \brief: analytical fonction for FS 
 * test case for a cube with Dirichlet conditions on all faces and no variation in z
 * case 1: 2d test with quadratic functions
 * case 2: 2d test with sinusoidal functions
 * case 3: 3d test with quadratic functions
 * case 4: 3d test with sinusoidal functions
 * case 5: 3d test with sinusoidal functions, no variations with z, non homogeneous Dirichlet conditions
 * case 6: 3d test with sinusoidal functions, non homogeneous Dirichlet conditions
 */

#include <math.h>
#include "../Numerics/types.h"
#include "../Numerics/constants.h"
#include "./fsanalyticals.h"
#include "../shared.h"

IssmDouble fx(IssmDouble x,IssmDouble y,IssmDouble z,int testid){ /*{{{*/ 
	IssmDouble p=2;
	IssmDouble q=2;
	IssmDouble a=1;

	switch(testid){
		case 1:
			z=y;
			return  4*pow(x, 2)*z*pow(x - 1, 2) + 4*pow(x, 2)*z*(z - 1)*(2*z - 1) + 4*pow(x, 2)*pow(x - 1, 2)*(z - 1) + 2*pow(x, 2)*pow(x - 1, 2)*(2*z - 1) + 16*x*z*(x - 1)*(z - 1)*(2*z - 1) - 4*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) + 6*pow(z, 2)*(6*pow(x, 2) - 6*x + 1) + 4*z*pow(x - 1, 2)*(z - 1)*(2*z - 1) - 2*z*(6*pow(x, 2) - 6*x + 1) + z - 1.0L/2.0L;
		case 2:
			z=y;
			return 10*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 3)*pow(sin(PI*p*z), 2)*cos(PI*p*z) - 2*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 3)*pow(cos(PI*p*z), 3) - 6*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*pow(sin(PI*p*z), 2)*pow(cos(PI*p*x), 2)*cos(PI*p*z) + PI*q*sin(PI*q*z)*cos(PI*q*x);
		case 3: 
			return 4*pow(x, 2)*y*z*pow(x - 1, 2)*(z - 1) + 4*pow(x, 2)*y*z*(y - 1)*(2*y - 1)*(z - 1) + 2*pow(x, 2)*y*pow(x - 1, 2)*(y - 1)*(2*y - 1) + 4*pow(x, 2)*z*pow(x - 1, 2)*(y - 1)*(z - 1) + 2*pow(x, 2)*z*pow(x - 1, 2)*(2*y - 1)*(z - 1) - 4*x*pow(y, 2)*z*(x - 1)*(y - 1)*(z - 1) - 2*x*pow(y, 2)*z*(2*x - 1)*(y - 1)*(z - 1) - 4*x*y*z*(x - 1)*pow(y - 1, 2)*(z - 1) + 16*x*y*z*(x - 1)*(y - 1)*(2*y - 1)*(z - 1) - 2*x*y*z*(2*x - 1)*pow(y - 1, 2)*(z - 1) - 2*pow(y, 2)*z*(x - 1)*(2*x - 1)*(y - 1)*(z - 1) + 4*y*z*pow(x - 1, 2)*(y - 1)*(2*y - 1)*(z - 1) - 2*y*z*(x - 1)*(2*x - 1)*pow(y - 1, 2)*(z - 1) + y - 1.0L/2.0L;
		case 4: 
			return 4*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) + 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x) + PI*q*sin(PI*q*y)*sin(PI*q*z)*cos(PI*q*x);
		case 5: 
			return 2.*(cos(PI*p*x) - 1)*PI*PI*p*p*sin(PI*p*y) + 3*PI*PI*p*p*sin(PI*p*y)*cos(PI*p*x) + PI*q*sin(PI*q*y)*cos(PI*q*x);
		case 6: 
			return 4. * PI*PI * p*p * (cos(p*PI*x)-1) * sin(p*PI*y) * sin(p*PI*z)+ 2. * PI*PI*p*p*  sin(p*PI*y)    * sin(p*PI*z) * cos(p*PI*x) + q * PI * cos(q*PI*x) * sin(q*PI*y) * sin(q*PI*z);
		case 7: 
			z=y;
			return 4*pow(x, 2)*z*pow(x - 1, 2) + 4*pow(x, 2)*z*(z - 1)*(2*z - 1) + 4*pow(x, 2)*pow(x - 1, 2)*(z - 1) + 2*pow(x, 2)*pow(x - 1, 2)*(2*z - 1) + 16*x*z*(x - 1)*(z - 1)*(2*z - 1) - 4*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) + 6*pow(z, 2)*(6*pow(x, 2) - 6*x + 1) + 4*z*pow(x - 1, 2)*(z - 1)*(2*z - 1) - 2*z*(6*pow(x, 2) - 6*x + 1) + 1;
		case 8: case 18:
			return 1.0;
		case 9:
			return 4*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) + 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x) + 2*x*z;
		case 10:
			return 4*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) + 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x) + PI*q*pow(z, a)*sin(PI*q*y)*cos(PI*q*x);
		case 11:
			z=y;
			return 32.0/5.0*pow(PI, 2)*sin(8*PI*z) + 8*PI*cos(8*PI*x + 1.0/3.0*PI);
		case 12:
			z=y;
			return 32.0/5.0*pow(PI, 2)*sin(8*PI*z);
		case 13:
			z=y;
			return 8.0*pow(PI, 2)*pow(x, 2)*(z - 2)*sin(4*PI*x*z) - 4.0*PI*x*cos(4*PI*x*z) + 16.0*pow(PI, 2)*pow(z, 2)*(z - 2)*sin(4*PI*x*z) - 0.25*PI*((16*pow(PI, 2)*x*z*(PI*x*z - PI*x)*cos(4*PI*x*z) + 4*pow(PI, 2)*x*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + 4*pow(PI, 2)*x*z*sin(4*PI*x*z) - 4*PI*x*(-PI*z + PI)*sin(4*PI*x*z) - 16*PI*x*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - 16*PI*z*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z) + 4*PI*(PI*x*z - PI*x)*sin(4*PI*x*z) - 8*(pow(PI, 2)*x*z - pow(PI, 2)*x)*sin(4*PI*x*z) - PI*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - PI*cos(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) + 3*(-4*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) + PI*x*cos(4*PI*x*z) + 4*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 4*PI*sin(4*PI*z)*cos(4*PI*x);
		case 14:
			z=y;
			return 8.0*pow(2, 1.0L/3.0L)*pow(PI, 2)*pow(z, 2)*(z - 2)*sin(4*PI*x*z)/pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 1.0L/3.0L) - 0.0266666666666667*pow(2, 1.0L/3.0L)*PI*z*(z - 2)*(800.0*pow(PI, 3)*pow(z, 3)*pow(z - 2, 2)*sin(4*PI*x*z)*cos(4*PI*x*z) - (-10.0*PI*x*(z - 2)*cos(4*PI*x*z) + 0.3125*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) - 2.5*sin(4*PI*x*z) - 2*PI*cos(4*PI*x))*(40.0*pow(PI, 2)*x*z*(z - 2)*sin(4*PI*x*z) - 10.0*PI*z*cos(4*PI*x*z) - 10.0*PI*(z - 2)*cos(4*PI*x*z) + 1.25*PI*(32*cos(4*PI*x)/pow(x, 2) - 4*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(PI*pow(x, 3)) - 4*(4*pow(PI, 2)*pow(z, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*pow(z, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) - 2*PI*z*(-PI*z + PI)*sin(4*PI*x*z) - 8*PI*z*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - (pow(PI, 2)*pow(z, 2) - 2*pow(PI, 2)*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 20*sin(4*PI*x)/(PI*pow(x, 3)) - 6*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 4)) - 6*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4)) + 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 5)) + 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 5))) + 8*pow(PI, 2)*sin(4*PI*x)) - (50*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 12.5*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 12.5*PI*x*cos(4*PI*x*z) - 50*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))*(4*pow(PI, 2)*x*z*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*x*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + pow(PI, 2)*x*z*sin(4*PI*x*z) - PI*x*(-PI*z + PI)*sin(4*PI*x*z) - 4.0*PI*x*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - 4*PI*z*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z) + PI*(PI*x*z - PI*x)*sin(4*PI*x*z) - 2*(pow(PI, 2)*x*z - pow(PI, 2)*x)*sin(4*PI*x*z) - 0.25*PI*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*cos(4*PI*x*z))/(pow(PI, 4)*pow(x, 6)) + 150*pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 7)))*cos(4*PI*x*z)/pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 4.0L/3.0L) + (1.0L/10.0L)*pow(2, 1.0L/3.0L)*(40.0*pow(PI, 2)*pow(x, 2)*(z - 2)*sin(4*PI*x*z) - 20.0*PI*x*cos(4*PI*x*z) - 1.25*PI*((16*pow(PI, 2)*x*z*(PI*x*z - PI*x)*cos(4*PI*x*z) + 4*pow(PI, 2)*x*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + 4*pow(PI, 2)*x*z*sin(4*PI*x*z) - 4*PI*x*(-PI*z + PI)*sin(4*PI*x*z) - 16*PI*x*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - 16*PI*z*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z) + 4*PI*(PI*x*z - PI*x)*sin(4*PI*x*z) - 8*(pow(PI, 2)*x*z - pow(PI, 2)*x)*sin(4*PI*x*z) - PI*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - PI*cos(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) + 3*(-4*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) + PI*x*cos(4*PI*x*z) + 4*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))))/pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 1.0L/3.0L) + 4*PI*sin(4*PI*z)*cos(4*PI*x) + (1.0L/150.0L)*pow(2, 1.0L/3.0L)*(-10.0*PI*x*(z - 2)*cos(4*PI*x*z) + 0.3125*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) - 2.5*sin(4*PI*x*z) - 2*PI*cos(4*PI*x))*(160.0*pow(PI, 3)*x*pow(z, 2)*pow(z - 2, 2)*sin(4*PI*x*z)*cos(4*PI*x*z) - 40.0*pow(PI, 2)*pow(z, 2)*(z - 2)*pow(cos(4*PI*x*z), 2) - 40.0*pow(PI, 2)*z*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (-8.0*pow(PI, 2)*pow(x, 2)*(z - 2)*sin(4*PI*x*z) + 4.0*PI*x*cos(4*PI*x*z) + 0.25*PI*((16*pow(PI, 2)*x*z*(PI*x*z - PI*x)*cos(4*PI*x*z) + 4*pow(PI, 2)*x*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + 4*pow(PI, 2)*x*z*sin(4*PI*x*z) - 4*PI*x*(-PI*z + PI)*sin(4*PI*x*z) - 16*PI*x*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - 16*PI*z*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z) + 4*PI*(PI*x*z - PI*x)*sin(4*PI*x*z) - 8*(pow(PI, 2)*x*z - pow(PI, 2)*x)*sin(4*PI*x*z) - PI*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - PI*cos(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) + 3*(-4*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) + PI*x*cos(4*PI*x*z) + 4*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))))*(-10.0*PI*x*(z - 2)*cos(4*PI*x*z) + 0.3125*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) - 2.5*sin(4*PI*x*z) - 2*PI*cos(4*PI*x)) - (10*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 2.5*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 2.5*PI*x*cos(4*PI*x*z) - 10*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))*(4*pow(PI, 2)*pow(x, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*pow(x, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + pow(PI, 2)*pow(x, 2)*sin(4*PI*x*z) - 8.0*PI*x*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z))/(pow(PI, 4)*pow(x, 6)))/pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 4.0L/3.0L);
		case 15:
			z=y;
			return -24000000000*pow(z - 1, 2) - 1000000*PI*sin(10*PI*x);
		case 21:
			z=y;
			return z - 4.0L/3.0L*pow(2, 1.0L/3.0L)*(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1))*(4*(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1))*(pow(x, 2)*z*(z - 1)*(2*z - 1) + 4*x*z*(x - 1)*(z - 1)*(2*z - 1) + z*pow(x - 1, 2)*(z - 1)*(2*z - 1)) + 4*(2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - 3*pow(z, 2)*(6*pow(x, 2) - 6*x + 1) + z*(6*pow(x, 2) - 6*x + 1))*(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x)) + (2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1))*(2*pow(x, 2)*z*(x - 1)*(z - 1) + pow(x, 2)*z*(x - 1)*(2*z - 1) + pow(x, 2)*(x - 1)*(z - 1)*(2*z - 1) + 2*x*z*pow(x - 1, 2)*(z - 1) + x*z*pow(x - 1, 2)*(2*z - 1) + x*pow(x - 1, 2)*(z - 1)*(2*z - 1) - 3*pow(z, 4)*(2*x - 1) + 6*pow(z, 3)*(2*x - 1) - 3*pow(z, 2)*(2*x - 1)))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 4.0L/3.0L) - 1.0L/3.0L*pow(2, 1.0L/3.0L)*(4*(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1))*(2*pow(x, 2)*z*(x - 1)*(z - 1) + pow(x, 2)*z*(x - 1)*(2*z - 1) + pow(x, 2)*(x - 1)*(z - 1)*(2*z - 1) + 2*x*z*pow(x - 1, 2)*(z - 1) + x*z*pow(x - 1, 2)*(2*z - 1) + x*pow(x - 1, 2)*(z - 1)*(2*z - 1)) + 4*(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x))*(2*pow(x, 3) - 3*pow(x, 2) + x + 6*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 6*z*(2*pow(x, 3) - 3*pow(x, 2) + x)) + (2*pow(x, 2)*z*pow(x - 1, 2) + 2*pow(x, 2)*pow(x - 1, 2)*(z - 1) + pow(x, 2)*pow(x - 1, 2)*(2*z - 1) - 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) + 3*pow(z, 2)*(6*pow(x, 2) - 6*x + 1) - z*(6*pow(x, 2) - 6*x + 1))*(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1)))*(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 4.0L/3.0L) + 2*pow(2, 1.0L/3.0L)*(pow(x, 2)*z*(z - 1)*(2*z - 1) + 4*x*z*(x - 1)*(z - 1)*(2*z - 1) + z*pow(x - 1, 2)*(z - 1)*(2*z - 1))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 1.0L/3.0L) - 0.5 + pow(2, 1.0L/3.0L)*(2*pow(x, 2)*z*pow(x - 1, 2) + 2*pow(x, 2)*pow(x - 1, 2)*(z - 1) + pow(x, 2)*pow(x - 1, 2)*(2*z - 1) - 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) + 3*pow(z, 2)*(6*pow(x, 2) - 6*x + 1) - z*(6*pow(x, 2) - 6*x + 1))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 1.0L/3.0L);
		case 22:
			z=y;
			return -2*pow(2, 1.0L/3.0L)*(pow(x, 2)*z*pow(z - 2, 2) + 4*x*z*(x - 2)*pow(z - 2, 2) + z*pow(x - 2, 2)*pow(z - 2, 2))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 1.0L/3.0L) + (2.0L/9.0L)*pow(2, 1.0L/3.0L)*(2*pow(x, 2)*z*(x - 2)*pow(z - 2, 2) + 2*x*z*pow(x - 2, 2)*pow(z - 2, 2) + 1)*(96*pow(x, 7) - 672*pow(x, 6) + 1728*pow(x, 5) - 1920*pow(x, 4) + 768*pow(x, 3) + 9*pow(z, 8)*(3*pow(x, 3) - 9*pow(x, 2) + 8*x - 2) - 96*pow(z, 7)*(3*pow(x, 3) - 9*pow(x, 2) + 8*x - 2) + pow(z, 6)*(207*pow(x, 5) - 1035*pow(x, 4) + 3012*pow(x, 3) - 4896*pow(x, 2) + 3512*x - 800) - 24*pow(z, 5)*(69*pow(x, 5) - 345*pow(x, 4) + 700*pow(x, 3) - 720*pow(x, 2) + 360*x - 64) + 2*pow(z, 4)*(27*pow(x, 7) - 189*pow(x, 6) + 2988*pow(x, 5) - 13050*pow(x, 4) + 22976*pow(x, 3) - 18240*pow(x, 2) + 6064*x - 576) - 8*pow(z, 3)*(36*pow(x, 7) - 252*pow(x, 6) + 1512*pow(x, 5) - 5040*pow(x, 4) + 7840*pow(x, 3) - 5385*pow(x, 2) + 1298*x - 6) + 48*pow(z, 2)*(11*pow(x, 7) - 77*pow(x, 6) + 276*pow(x, 5) - 610*pow(x, 4) + 768*pow(x, 3) - 486*pow(x, 2) + 124*x - 4) - 96*z*(4*pow(x, 7) - 28*pow(x, 6) + 72*pow(x, 5) - 80*pow(x, 4) + 32*pow(x, 3) - 3*pow(x, 2) + 6*x - 2))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 4.0L/3.0L) - pow(2, 1.0L/3.0L)*(pow(x, 2)*z*pow(x - 2, 2) + 2*pow(x, 2)*pow(x - 2, 2)*(z - 2) - 2*pow(z, 3)*(3*pow(x, 2) - 6*x + 2) + 8*pow(z, 2)*(3*pow(x, 2) - 6*x + 2) - 8*z*(3*pow(x, 2) - 6*x + 2))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 1.0L/3.0L) - 1.0L/27.0L*pow(2, 1.0L/3.0L)*(6*pow(x, 2)*z*pow(x - 2, 2)*(z - 2) + 3*pow(x, 2)*pow(x - 2, 2)*pow(z - 2, 2) - 3*pow(z, 4)*(3*pow(x, 2) - 6*x + 2) + 16*pow(z, 3)*(3*pow(x, 2) - 6*x + 2) - 24*pow(z, 2)*(3*pow(x, 2) - 6*x + 2))*(48*pow(x, 8) - 384*pow(x, 7) + 1152*pow(x, 6) - 1536*pow(x, 5) + 768*pow(x, 4) - 96*pow(x, 3) + 288*pow(x, 2) - 192*x - 6*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + 56*pow(z, 6)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - pow(z, 5)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) + 20*pow(z, 4)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) - pow(z, 3)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) + 12*pow(z, 2)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) - 12*z*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 4.0L/3.0L) + 4*PI*cos(4*PI*x + (1.0L/3.0L)*PI);
		case 24:
			return 2*pow(2, 1.0L/3.0L)*pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x)/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L) - 2.0L/3.0L*pow(2, 1.0L/3.0L)*PI*p*(12*pow(PI, 3)*pow(p, 3)*sin(PI*p*x)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2)*cos(PI*p*x) - (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*cos(PI*p*x)*cos(PI*p*y) + pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*cos(PI*p*x)*cos(PI*p*z)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z)))*sin(PI*p*x)*sin(PI*p*y)*sin(PI*p*z)/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) + PI*q*sin(PI*q*y)*sin(PI*q*z)*cos(PI*q*x) - 1.0L/6.0L*pow(2, 1.0L/3.0L)*(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(12*pow(PI, 3)*pow(p, 3)*pow(sin(PI*p*x), 2)*sin(PI*p*y)*pow(sin(PI*p*z), 2)*cos(PI*p*y) + (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*cos(PI*p*x)*cos(PI*p*y) - 2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*cos(PI*p*y)*cos(PI*p*z)))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) - 1.0L/6.0L*pow(2, 1.0L/3.0L)*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(12*pow(PI, 3)*pow(p, 3)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*sin(PI*p*z)*cos(PI*p*z) + (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(-2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*cos(PI*p*y)*cos(PI*p*z) + pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*cos(PI*p*x)*cos(PI*p*z)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x)))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) + pow(2, 1.0L/3.0L)*(2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L);

		case 101: 
			return 4*pow(x, 2)*y*z*pow(x - 1, 2)*(z - 1) + 8*pow(x, 2)*y*z*(y - 1)*(2*y - 1)*(z - 1) + 2*pow(x, 2)*y*pow(x - 1, 2)*(y - 1)*(2*y - 1) + 4*pow(x, 2)*z*pow(x - 1, 2)*(y - 1)*(z - 1) + 2*pow(x, 2)*z*pow(x - 1, 2)*(2*y - 1)*(z - 1) - 12*x*pow(y, 2)*z*(x - 1)*(y - 1)*(z - 1) - 6*x*pow(y, 2)*z*(2*x - 1)*(y - 1)*(z - 1) - 12*x*y*z*(x - 1)*pow(y - 1, 2)*(z - 1) + 32*x*y*z*(x - 1)*(y - 1)*(2*y - 1)*(z - 1) - 6*x*y*z*(2*x - 1)*pow(y - 1, 2)*(z - 1) - 6*pow(y, 2)*z*(x - 1)*(2*x - 1)*(y - 1)*(z - 1) + 8*y*z*pow(x - 1, 2)*(y - 1)*(2*y - 1)*(z - 1) - 6*y*z*(x - 1)*(2*x - 1)*pow(y - 1, 2)*(z - 1);
		default:
			_error_("FS analytical solution"<<testid<<" not implemented yet");
	}
}
/*}}}*/
IssmDouble fy(IssmDouble x,IssmDouble y,IssmDouble z,int testid){ /*{{{*/ 
	IssmDouble p=2;
	IssmDouble q=2;
	IssmDouble a=1;

	switch(testid){
		case 1:
			z=y;
			return -8*pow(x, 3) + 4*pow(x, 2)*z*(x - 1)*(z - 1) + 2*pow(x, 2)*z*(x - 1)*(2*z - 1) + 2*pow(x, 2)*(x - 1)*(z - 1)*(2*z - 1) + 12*pow(x, 2) + 4*x*z*pow(x - 1, 2)*(z - 1) + 2*x*z*pow(x - 1, 2)*(2*z - 1) + 2*x*pow(x - 1, 2)*(z - 1)*(2*z - 1) - 3*x - 6*pow(z, 4)*(2*x - 1) + 12*pow(z, 3)*(2*x - 1) - 6*pow(z, 2)*(2*x - 1) - 24*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + 24*z*(2*pow(x, 3) - 3*pow(x, 2) + x) - 1.0L/2.0L;
		case 2: 
			z=y;
			return -10*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*z), 3)*cos(PI*p*x) + 6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*sin(PI*p*z)*cos(PI*p*x)*pow(cos(PI*p*z), 2) + 2*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*z), 3)*pow(cos(PI*p*x), 3) + PI*q*sin(PI*q*x)*cos(PI*q*z);
		case 3: 
			return 4*pow(x, 2)*y*z*(x - 1)*(y - 1)*(z - 1) + 2*pow(x, 2)*y*z*(x - 1)*(2*y - 1)*(z - 1) + 2*pow(x, 2)*z*(x - 1)*(y - 1)*(2*y - 1)*(z - 1) - 4*x*pow(y, 2)*z*(x - 1)*(2*x - 1)*(z - 1) - 4*x*pow(y, 2)*z*pow(y - 1, 2)*(z - 1) - 2*x*pow(y, 2)*(x - 1)*(2*x - 1)*pow(y - 1, 2) + 4*x*y*z*pow(x - 1, 2)*(y - 1)*(z - 1) + 2*x*y*z*pow(x - 1, 2)*(2*y - 1)*(z - 1) - 16*x*y*z*(x - 1)*(2*x - 1)*(y - 1)*(z - 1) + 2*x*z*pow(x - 1, 2)*(y - 1)*(2*y - 1)*(z - 1) - 4*x*z*(x - 1)*(2*x - 1)*pow(y - 1, 2)*(z - 1) + x - 4*pow(y, 2)*z*(x - 1)*pow(y - 1, 2)*(z - 1) - 2*pow(y, 2)*z*(2*x - 1)*pow(y - 1, 2)*(z - 1) - 1.0L/2.0L;
		case 4: 
			return -2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y) + PI*q*sin(PI*q*x)*sin(PI*q*z)*cos(PI*q*y);
		case 5: 
			return -(cos(PI*p*y) - 1)*PI*PI*p*p*sin(PI*p*x) + PI*q*sin(PI*q*x)*cos(PI*q*y);
		case 6: 
			return - 4. * PI*PI * p*p * (cos(p*PI*y)-1) * sin(p*PI*x) * sin(p*PI*z)-  2. * PI*PI * p*p *  sin(p*PI*x)    * cos(p*PI*y) * sin(p*PI*z)+ q * PI * sin(q*PI*x) * cos(q*PI*y) * sin(q*PI*z);
		case 7: 
			z=y;
			return -8*pow(x, 3) + 4*pow(x, 2)*z*(x - 1)*(z - 1) + 2*pow(x, 2)*z*(x - 1)*(2*z - 1) + 2*pow(x, 2)*(x - 1)*(z - 1)*(2*z - 1) + 12*pow(x, 2) + 4*x*z*pow(x - 1, 2)*(z - 1) + 2*x*z*pow(x - 1, 2)*(2*z - 1) + 2*x*pow(x - 1, 2)*(z - 1)*(2*z - 1) - 4*x - 6*pow(z, 4)*(2*x - 1) + 12*pow(z, 3)*(2*x - 1) - 6*pow(z, 2)*(2*x - 1) - 24*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + 24*z*(2*pow(x, 3) - 3*pow(x, 2) + x);
		case 8: case 18:
			return 1.0;
		case 9: 
			return -2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y) + 2*y*z;
		case 10:
			return -2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y) + PI*q*pow(z, a)*sin(PI*q*x)*cos(PI*q*y);
		case 11:
			z=y;
			return 32.0/5.0*pow(PI, 2)*sin(8*PI*x) - 10.;
		case 12:
			z=y;
			return 32.0/5.0*pow(PI, 2)*sin(8*PI*x) - 100;
		case 13:
			z=y;
			return 8.0*pow(PI, 2)*x*z*(z - 2)*sin(4*PI*x*z) - 2.0*PI*z*cos(4*PI*x*z) - 2.0*PI*(z - 2)*cos(4*PI*x*z) + 0.25*PI*(32*cos(4*PI*x)/pow(x, 2) - 4*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(PI*pow(x, 3)) - 4*(4*pow(PI, 2)*pow(z, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*pow(z, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) - 2*PI*z*(-PI*z + PI)*sin(4*PI*x*z) - 8*PI*z*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - (pow(PI, 2)*pow(z, 2) - 2*pow(PI, 2)*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 20*sin(4*PI*x)/(PI*pow(x, 3)) - 6*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 4)) - 6*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4)) + 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 5)) + 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 5))) + 4*PI*sin(4*PI*x)*cos(4*PI*z) + (8.0L/5.0L)*pow(PI, 2)*sin(4*PI*x) + 2*(-4.0*pow(PI, 2)*pow(x, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) - 1.0*pow(PI, 2)*pow(x, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) - 1.0*pow(PI, 2)*pow(x, 2)*sin(4*PI*x*z) + 8.0*PI*x*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z))/(pow(PI, 2)*pow(x, 3));
		case 14:
			z=y;
			return 4*PI*sin(4*PI*x)*cos(4*PI*z) + (1.0L/10.0L)*pow(2, 1.0L/3.0L)*(40.0*pow(PI, 2)*x*z*(z - 2)*sin(4*PI*x*z) - 10.0*PI*z*cos(4*PI*x*z) - 10.0*PI*(z - 2)*cos(4*PI*x*z) + 1.25*PI*(32*cos(4*PI*x)/pow(x, 2) - 4*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(PI*pow(x, 3)) - 4*(4*pow(PI, 2)*pow(z, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*pow(z, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) - 2*PI*z*(-PI*z + PI)*sin(4*PI*x*z) - 8*PI*z*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - (pow(PI, 2)*pow(z, 2) - 2*pow(PI, 2)*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 20*sin(4*PI*x)/(PI*pow(x, 3)) - 6*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 4)) - 6*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4)) + 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 5)) + 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 5))) + 8*pow(PI, 2)*sin(4*PI*x))/pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 1.0L/3.0L) + (1.0L/750.0L)*pow(2, 1.0L/3.0L)*(-10.0*PI*x*(z - 2)*cos(4*PI*x*z) + 0.3125*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) - 2.5*sin(4*PI*x*z) - 2*PI*cos(4*PI*x))*(800.0*pow(PI, 3)*pow(z, 3)*pow(z - 2, 2)*sin(4*PI*x*z)*cos(4*PI*x*z) - (-10.0*PI*x*(z - 2)*cos(4*PI*x*z) + 0.3125*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) - 2.5*sin(4*PI*x*z) - 2*PI*cos(4*PI*x))*(40.0*pow(PI, 2)*x*z*(z - 2)*sin(4*PI*x*z) - 10.0*PI*z*cos(4*PI*x*z) - 10.0*PI*(z - 2)*cos(4*PI*x*z) + 1.25*PI*(32*cos(4*PI*x)/pow(x, 2) - 4*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(PI*pow(x, 3)) - 4*(4*pow(PI, 2)*pow(z, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*pow(z, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) - 2*PI*z*(-PI*z + PI)*sin(4*PI*x*z) - 8*PI*z*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - (pow(PI, 2)*pow(z, 2) - 2*pow(PI, 2)*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 20*sin(4*PI*x)/(PI*pow(x, 3)) - 6*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 4)) - 6*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4)) + 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 5)) + 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 5))) + 8*pow(PI, 2)*sin(4*PI*x)) - (50*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 12.5*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 12.5*PI*x*cos(4*PI*x*z) - 50*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))*(4*pow(PI, 2)*x*z*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*x*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + pow(PI, 2)*x*z*sin(4*PI*x*z) - PI*x*(-PI*z + PI)*sin(4*PI*x*z) - 4.0*PI*x*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - 4*PI*z*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z) + PI*(PI*x*z - PI*x)*sin(4*PI*x*z) - 2*(pow(PI, 2)*x*z - pow(PI, 2)*x)*sin(4*PI*x*z) - 0.25*PI*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*cos(4*PI*x*z))/(pow(PI, 4)*pow(x, 6)) + 150*pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 7)))/pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 4.0L/3.0L) - pow(2, 1.0L/3.0L)*(4.0*pow(PI, 2)*pow(x, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*pow(x, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + pow(PI, 2)*pow(x, 2)*sin(4*PI*x*z) - 8.0*PI*x*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z))/(pow(PI, 2)*pow(x, 3)*pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 1.0L/3.0L)) - 1.0L/15.0L*pow(2, 1.0L/3.0L)*(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) + (-1.0*pow(PI, 2)*pow(x, 2)*z + pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))*(160.0*pow(PI, 3)*x*pow(z, 2)*pow(z - 2, 2)*sin(4*PI*x*z)*cos(4*PI*x*z) - 40.0*pow(PI, 2)*pow(z, 2)*(z - 2)*pow(cos(4*PI*x*z), 2) - 40.0*pow(PI, 2)*z*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (-8.0*pow(PI, 2)*pow(x, 2)*(z - 2)*sin(4*PI*x*z) + 4.0*PI*x*cos(4*PI*x*z) + 0.25*PI*((16*pow(PI, 2)*x*z*(PI*x*z - PI*x)*cos(4*PI*x*z) + 4*pow(PI, 2)*x*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + 4*pow(PI, 2)*x*z*sin(4*PI*x*z) - 4*PI*x*(-PI*z + PI)*sin(4*PI*x*z) - 16*PI*x*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*cos(4*PI*x*z) - 16*PI*z*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z) + 4*PI*(PI*x*z - PI*x)*sin(4*PI*x*z) - 8*(pow(PI, 2)*x*z - pow(PI, 2)*x)*sin(4*PI*x*z) - PI*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - PI*cos(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) + 3*(-4*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) + PI*x*cos(4*PI*x*z) + 4*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))))*(-10.0*PI*x*(z - 2)*cos(4*PI*x*z) + 0.3125*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) - 2.5*sin(4*PI*x*z) - 2*PI*cos(4*PI*x)) - (10*PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 2.5*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 2.5*PI*x*cos(4*PI*x*z) - 10*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z))*(4*pow(PI, 2)*pow(x, 2)*(PI*x*z - PI*x)*cos(4*PI*x*z) + pow(PI, 2)*pow(x, 2)*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z) + pow(PI, 2)*pow(x, 2)*sin(4*PI*x*z) - 8.0*PI*x*(pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*cos(4*PI*x*z))/(pow(PI, 4)*pow(x, 6)))/(pow(PI, 2)*pow(x, 3)*pow(4.0*pow(PI, 2)*pow(z, 2)*pow(z - 2, 2)*pow(cos(4*PI*x*z), 2) + (1.0L/2.0L)*pow(2.0*PI*x*(z - 2)*cos(4*PI*x*z) - 0.0625*PI*(16*sin(4*PI*x)/(PI*pow(x, 2)) + 4*(8*pow(PI, 2)*pow(x, 2) + 1)*cos(4*PI*x)/(pow(PI, 2)*pow(x, 3)) + 4*(-4*PI*z*(PI*x*z - PI*x)*sin(4*PI*x*z) + PI*z*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - (-PI*z + PI)*cos(4*PI*x*z) + 4*(pow(PI, 2)*x*pow(z, 2) - 2*pow(PI, 2)*x*z)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 3)) - 3*(8*pow(PI, 2)*pow(x, 2) + 1)*sin(4*PI*x)/(pow(PI, 3)*pow(x, 4)) - 3*(4*(PI*x*z - PI*x)*cos(4*PI*x*z) + (8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*sin(4*PI*x*z))/(pow(PI, 3)*pow(x, 4))) + 0.5*sin(4*PI*x*z) + (2.0L/5.0L)*PI*cos(4*PI*x), 2) + pow(PI*x*(PI*x*z - PI*x)*sin(4*PI*x*z) - 0.25*PI*x*(8*pow(PI, 2)*pow(x, 2)*pow(z, 2) - 16*pow(PI, 2)*pow(x, 2)*z - 1)*cos(4*PI*x*z) - 0.25*PI*x*cos(4*PI*x*z) - (pow(PI, 2)*pow(x, 2)*z - pow(PI, 2)*pow(x, 2))*sin(4*PI*x*z), 2)/(pow(PI, 4)*pow(x, 6)), 4.0L/3.0L));
		case 15:
			z=y;
			return 54000000000000*pow(PI, 2)*sin(30*PI*x) + 6000000000000*pow(PI, 2)*sin(10*PI*x + (1.0L/5.0L)*PI) - 10000000;
		case 21:
			z=y;
			return x + (4.0L/3.0L)*pow(2, 1.0L/3.0L)*(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x))*(4*(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1))*(2*pow(x, 2)*z*(x - 1)*(z - 1) + pow(x, 2)*z*(x - 1)*(2*z - 1) + pow(x, 2)*(x - 1)*(z - 1)*(2*z - 1) + 2*x*z*pow(x - 1, 2)*(z - 1) + x*z*pow(x - 1, 2)*(2*z - 1) + x*pow(x - 1, 2)*(z - 1)*(2*z - 1)) + 4*(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x))*(2*pow(x, 3) - 3*pow(x, 2) + x + 6*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 6*z*(2*pow(x, 3) - 3*pow(x, 2) + x)) + (2*pow(x, 2)*z*pow(x - 1, 2) + 2*pow(x, 2)*pow(x - 1, 2)*(z - 1) + pow(x, 2)*pow(x - 1, 2)*(2*z - 1) - 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) + 3*pow(z, 2)*(6*pow(x, 2) - 6*x + 1) - z*(6*pow(x, 2) - 6*x + 1))*(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1)))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 4.0L/3.0L) - 1.0L/3.0L*pow(2, 1.0L/3.0L)*(4*(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1))*(pow(x, 2)*z*(z - 1)*(2*z - 1) + 4*x*z*(x - 1)*(z - 1)*(2*z - 1) + z*pow(x - 1, 2)*(z - 1)*(2*z - 1)) + 4*(2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - 3*pow(z, 2)*(6*pow(x, 2) - 6*x + 1) + z*(6*pow(x, 2) - 6*x + 1))*(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x)) + (2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1))*(2*pow(x, 2)*z*(x - 1)*(z - 1) + pow(x, 2)*z*(x - 1)*(2*z - 1) + pow(x, 2)*(x - 1)*(z - 1)*(2*z - 1) + 2*x*z*pow(x - 1, 2)*(z - 1) + x*z*pow(x - 1, 2)*(2*z - 1) + x*pow(x - 1, 2)*(z - 1)*(2*z - 1) - 3*pow(z, 4)*(2*x - 1) + 6*pow(z, 3)*(2*x - 1) - 3*pow(z, 2)*(2*x - 1)))*(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 4.0L/3.0L) - 0.5 - 2*pow(2, 1.0L/3.0L)*(2*pow(x, 3) - 3*pow(x, 2) + x + 6*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 6*z*(2*pow(x, 3) - 3*pow(x, 2) + x))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 1.0L/3.0L) + pow(2, 1.0L/3.0L)*(2*pow(x, 2)*z*(x - 1)*(z - 1) + pow(x, 2)*z*(x - 1)*(2*z - 1) + pow(x, 2)*(x - 1)*(z - 1)*(2*z - 1) + 2*x*z*pow(x - 1, 2)*(z - 1) + x*z*pow(x - 1, 2)*(2*z - 1) + x*pow(x - 1, 2)*(z - 1)*(2*z - 1) - 3*pow(z, 4)*(2*x - 1) + 6*pow(z, 3)*(2*x - 1) - 3*pow(z, 2)*(2*x - 1))/pow(4*pow(pow(x, 2)*z*(x - 1)*(z - 1)*(2*z - 1) + x*z*pow(x - 1, 2)*(z - 1)*(2*z - 1), 2) + 4*pow(2*pow(z, 3)*(2*pow(x, 3) - 3*pow(x, 2) + x) - 3*pow(z, 2)*(2*pow(x, 3) - 3*pow(x, 2) + x) + z*(2*pow(x, 3) - 3*pow(x, 2) + x), 2) + (1.0L/2.0L)*pow(2*pow(x, 2)*z*pow(x - 1, 2)*(z - 1) + pow(x, 2)*z*pow(x - 1, 2)*(2*z - 1) + pow(x, 2)*pow(x - 1, 2)*(z - 1)*(2*z - 1) - pow(z, 4)*(6*pow(x, 2) - 6*x + 1) + 2*pow(z, 3)*(6*pow(x, 2) - 6*x + 1) - pow(z, 2)*(6*pow(x, 2) - 6*x + 1), 2), 1.0L/3.0L);
		case 22:
			z=y;
			return (2.0L/9.0L)*pow(2, 1.0L/3.0L)*(4*pow(z, 3)*(pow(x, 3) - 3*pow(x, 2) + 2*x) - 16*pow(z, 2)*(pow(x, 3) - 3*pow(x, 2) + 2*x) + 16*z*(pow(x, 3) - 3*pow(x, 2) + 2*x) + 1)*(48*pow(x, 8) - 384*pow(x, 7) + 1152*pow(x, 6) - 1536*pow(x, 5) + 768*pow(x, 4) - 96*pow(x, 3) + 288*pow(x, 2) - 192*x - 6*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + 56*pow(z, 6)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - pow(z, 5)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) + 20*pow(z, 4)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) - pow(z, 3)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) + 12*pow(z, 2)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) - 12*z*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 4.0L/3.0L) + 4*pow(2, 1.0L/3.0L)*(4*pow(x, 3) - 12*pow(x, 2) + 8*x + 3*pow(z, 2)*(pow(x, 3) - 3*pow(x, 2) + 2*x) - 8*z*(pow(x, 3) - 3*pow(x, 2) + 2*x))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 1.0L/3.0L) + (1.0L/27.0L)*pow(2, 1.0L/3.0L)*(6*pow(x, 2)*z*pow(x - 2, 2)*(z - 2) + 3*pow(x, 2)*pow(x - 2, 2)*pow(z - 2, 2) - 3*pow(z, 4)*(3*pow(x, 2) - 6*x + 2) + 16*pow(z, 3)*(3*pow(x, 2) - 6*x + 2) - 24*pow(z, 2)*(3*pow(x, 2) - 6*x + 2))*(96*pow(x, 7) - 672*pow(x, 6) + 1728*pow(x, 5) - 1920*pow(x, 4) + 768*pow(x, 3) + 9*pow(z, 8)*(3*pow(x, 3) - 9*pow(x, 2) + 8*x - 2) - 96*pow(z, 7)*(3*pow(x, 3) - 9*pow(x, 2) + 8*x - 2) + pow(z, 6)*(207*pow(x, 5) - 1035*pow(x, 4) + 3012*pow(x, 3) - 4896*pow(x, 2) + 3512*x - 800) - 24*pow(z, 5)*(69*pow(x, 5) - 345*pow(x, 4) + 700*pow(x, 3) - 720*pow(x, 2) + 360*x - 64) + 2*pow(z, 4)*(27*pow(x, 7) - 189*pow(x, 6) + 2988*pow(x, 5) - 13050*pow(x, 4) + 22976*pow(x, 3) - 18240*pow(x, 2) + 6064*x - 576) - 8*pow(z, 3)*(36*pow(x, 7) - 252*pow(x, 6) + 1512*pow(x, 5) - 5040*pow(x, 4) + 7840*pow(x, 3) - 5385*pow(x, 2) + 1298*x - 6) + 48*pow(z, 2)*(11*pow(x, 7) - 77*pow(x, 6) + 276*pow(x, 5) - 610*pow(x, 4) + 768*pow(x, 3) - 486*pow(x, 2) + 124*x - 4) - 96*z*(4*pow(x, 7) - 28*pow(x, 6) + 72*pow(x, 5) - 80*pow(x, 4) + 32*pow(x, 3) - 3*pow(x, 2) + 6*x - 2))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 4.0L/3.0L) - pow(2, 1.0L/3.0L)*(2*pow(x, 2)*z*(x - 2)*(z - 2) + pow(x, 2)*(x - 2)*pow(z - 2, 2) + 2*x*z*pow(x - 2, 2)*(z - 2) + x*pow(x - 2, 2)*pow(z - 2, 2) - 3*pow(z, 4)*(x - 1) + 16*pow(z, 3)*(x - 1) - 24*pow(z, 2)*(x - 1))/pow(8*pow(x, 8) - 64*pow(x, 7) + 192*pow(x, 6) - 256*pow(x, 5) + 128*pow(x, 4) + (1.0L/2.0L)*pow(z, 8)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) - 16.0L/3.0L*pow(z, 7)*(9*pow(x, 4) - 36*pow(x, 3) + 48*pow(x, 2) - 24*x + 4) + (1.0L/9.0L)*pow(z, 6)*(207*pow(x, 6) - 1242*pow(x, 5) + 4518*pow(x, 4) - 9792*pow(x, 3) + 10536*pow(x, 2) - 4800*x + 800) - 8.0L/3.0L*pow(z, 5)*(69*pow(x, 6) - 414*pow(x, 5) + 1050*pow(x, 4) - 1440*pow(x, 3) + 1080*pow(x, 2) - 384*x + 64) + (1.0L/6.0L)*pow(z, 4)*(27*pow(x, 8) - 216*pow(x, 7) + 3984*pow(x, 6) - 20880*pow(x, 5) + 45952*pow(x, 4) - 48640*pow(x, 3) + 24256*pow(x, 2) - 4608*x + 768) - 8.0L/3.0L*pow(z, 3)*(9*pow(x, 8) - 72*pow(x, 7) + 504*pow(x, 6) - 2016*pow(x, 5) + 3920*pow(x, 4) - 3590*pow(x, 3) + 1298*pow(x, 2) - 12*x) + 4*pow(z, 2)*(11*pow(x, 8) - 88*pow(x, 7) + 368*pow(x, 6) - 976*pow(x, 5) + 1536*pow(x, 4) - 1296*pow(x, 3) + 496*pow(x, 2) - 32*x) - 32*z*(pow(x, 8) - 8*pow(x, 7) + 24*pow(x, 6) - 32*pow(x, 5) + 16*pow(x, 4) - 2*pow(x, 3) + 6*pow(x, 2) - 4*x) + 2, 1.0L/3.0L) - 10;
		case 24:
			return -pow(2, 1.0L/3.0L)*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y)/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L) + (1.0L/3.0L)*pow(2, 1.0L/3.0L)*PI*p*(12*pow(PI, 3)*pow(p, 3)*pow(sin(PI*p*x), 2)*sin(PI*p*y)*pow(sin(PI*p*z), 2)*cos(PI*p*y) + (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*cos(PI*p*x)*cos(PI*p*y) - 2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*cos(PI*p*y)*cos(PI*p*z)))*sin(PI*p*x)*sin(PI*p*y)*sin(PI*p*z)/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) + PI*q*sin(PI*q*x)*sin(PI*q*z)*cos(PI*q*y) - 1.0L/6.0L*pow(2, 1.0L/3.0L)*(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(12*pow(PI, 3)*pow(p, 3)*sin(PI*p*x)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2)*cos(PI*p*x) - (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*cos(PI*p*x)*cos(PI*p*y) + pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*cos(PI*p*x)*cos(PI*p*z)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z)))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) - 1.0L/6.0L*pow(2, 1.0L/3.0L)*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(12*pow(PI, 3)*pow(p, 3)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*sin(PI*p*z)*cos(PI*p*z) + (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(-2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*cos(PI*p*y)*cos(PI*p*z) + pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*cos(PI*p*x)*cos(PI*p*z)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x)))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) - 1.0L/2.0L*pow(2, 1.0L/3.0L)*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L) - 1.0L/2.0L*pow(2, 1.0L/3.0L)*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L); 

		case 101: 
			return 12*pow(x, 2)*y*z*(x - 1)*(y - 1)*(z - 1) + 6*pow(x, 2)*y*z*(x - 1)*(2*y - 1)*(z - 1) + 6*pow(x, 2)*z*(x - 1)*(y - 1)*(2*y - 1)*(z - 1) - 8*x*pow(y, 2)*z*(x - 1)*(2*x - 1)*(z - 1) - 4*x*pow(y, 2)*z*pow(y - 1, 2)*(z - 1) - 2*x*pow(y, 2)*(x - 1)*(2*x - 1)*pow(y - 1, 2) + 12*x*y*z*pow(x - 1, 2)*(y - 1)*(z - 1) + 6*x*y*z*pow(x - 1, 2)*(2*y - 1)*(z - 1) - 32*x*y*z*(x - 1)*(2*x - 1)*(y - 1)*(z - 1) + 6*x*z*pow(x - 1, 2)*(y - 1)*(2*y - 1)*(z - 1) - 8*x*z*(x - 1)*(2*x - 1)*pow(y - 1, 2)*(z - 1) - 4*pow(y, 2)*z*(x - 1)*pow(y - 1, 2)*(z - 1) - 2*pow(y, 2)*z*(2*x - 1)*pow(y - 1, 2)*(z - 1);
		default:
			_error_("FS analytical solution"<<testid<<" not implemented yet");
	}
}
/*}}}*/
IssmDouble fz(IssmDouble x,IssmDouble y,IssmDouble z,int testid){ /*{{{*/ 
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble a = 1.0;

	switch(testid){
		case 1: case 2: case 7: case 8: case 11:  case 12: case 13: case 14: case 15: case 18: case 21: case 22:
			return 0.;
		case 3: 
			return 2*pow(x, 2)*y*z*(x - 1)*(y - 1)*(2*y - 1) + 2*pow(x, 2)*y*(x - 1)*(y - 1)*(2*y - 1)*(z - 1) - 2*x*pow(y, 2)*z*(x - 1)*(2*x - 1)*(y - 1) - 2*x*pow(y, 2)*(x - 1)*(2*x - 1)*(y - 1)*(z - 1) + 2*x*y*z*pow(x - 1, 2)*(y - 1)*(2*y - 1) - 2*x*y*z*(x - 1)*(2*x - 1)*pow(y - 1, 2) + 2*x*y*pow(x - 1, 2)*(y - 1)*(2*y - 1)*(z - 1) - 2*x*y*(x - 1)*(2*x - 1)*pow(y - 1, 2)*(z - 1);
		case 4: 
			return -2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*z) - 1)*sin(PI*p*x)*sin(PI*p*y) - pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z) + PI*q*sin(PI*q*x)*sin(PI*q*y)*cos(PI*q*z);
		case 5: 
			return 2*PI*PI*p*p*sin(PI*p*x)*sin(PI*p*y);
		case 6: 
			return - 2. * PI*PI * p*p * (cos(p*PI*z)-1) * sin(p*PI*x) * sin(p*PI*y)-PI*PI * p*p *  sin(p*PI*x)    * sin(p*PI*y) * cos(p*PI*z)+ q * PI * sin(q*PI*x) * sin(q*PI*y) * cos(q*PI*z);
		case 9:
			return -2*pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) - pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z) + pow(x, 2) + pow(y, 2);
		case 10:
			return a*pow(z, a - 1)*(sin(PI*q*x)*sin(PI*q*y) + 1) - 2*pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) - pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z);
		case 24:
			return -pow(2, 1.0L/3.0L)*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z)/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L) + (1.0L/3.0L)*pow(2, 1.0L/3.0L)*PI*p*(12*pow(PI, 3)*pow(p, 3)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*sin(PI*p*z)*cos(PI*p*z) + (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(-2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*cos(PI*p*y)*cos(PI*p*z) + pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*cos(PI*p*x)*cos(PI*p*z)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x)))*sin(PI*p*x)*sin(PI*p*y)*sin(PI*p*z)/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) + PI*q*sin(PI*q*x)*sin(PI*q*y)*cos(PI*q*z) - 1.0L/6.0L*pow(2, 1.0L/3.0L)*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(12*pow(PI, 3)*pow(p, 3)*pow(sin(PI*p*x), 2)*sin(PI*p*y)*pow(sin(PI*p*z), 2)*cos(PI*p*y) + (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*sin(PI*p*y)*sin(PI*p*z) - pow(PI, 2)*pow(p, 2)*sin(PI*p*y)*sin(PI*p*z)*cos(PI*p*x)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*cos(PI*p*x)*cos(PI*p*y) - 2*pow(PI, 2)*pow(p, 2)*(cos(PI*p*x) - 1)*cos(PI*p*y)*cos(PI*p*z)))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) - 1.0L/6.0L*pow(2, 1.0L/3.0L)*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(12*pow(PI, 3)*pow(p, 3)*sin(PI*p*x)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2)*cos(PI*p*x) - (-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x))*(pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*sin(PI*p*x)*sin(PI*p*z) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*z)*cos(PI*p*y)) + (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*cos(PI*p*x)*cos(PI*p*y) + pow(PI, 2)*pow(p, 2)*(cos(PI*p*y) - 1)*cos(PI*p*x)*cos(PI*p*z)) - (pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z))*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z)))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 4.0L/3.0L) - 1.0L/2.0L*pow(2, 1.0L/3.0L)*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) - 2*pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L) - 1.0L/2.0L*pow(2, 1.0L/3.0L)*(pow(PI, 3)*pow(p, 3)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*sin(PI*p*y) + pow(PI, 2)*pow(p, 2)*sin(PI*p*x)*sin(PI*p*y)*cos(PI*p*z))/pow(6*pow(PI, 2)*pow(p, 2)*pow(sin(PI*p*x), 2)*pow(sin(PI*p*y), 2)*pow(sin(PI*p*z), 2) + (1.0L/2.0L)*pow(-2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*z)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*z)*cos(PI*p*x), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*x)*cos(PI*p*y) + PI*p*(cos(PI*p*y) - 1)*sin(PI*p*x)*cos(PI*p*z), 2) + (1.0L/2.0L)*pow(pow(PI, 2)*pow(p, 2)*(cos(PI*p*z)/(PI*p) - 1/(PI*p))*sin(PI*p*y)*cos(PI*p*x) - 2*PI*p*(cos(PI*p*x) - 1)*sin(PI*p*y)*cos(PI*p*z), 2), 1.0L/3.0L);
		default:
			_error_("FS analytical solution"<<testid<<" not implemented yet");
	}
}
/*}}}*/
IssmDouble alpha(IssmDouble x,IssmDouble y,IssmDouble z,int testid){ /*{{{*/ 
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   

	switch(testid){
		case 1: case 2: case 3: case 4: case 5: case 6: case 7: case 8: case 9: case 10: case 11: case 12: case 13: case 14: case 21: case 22:
			return 0.;
		case 15:
			return 1.e+5;
		case 18:
			return (120.0L/109.0L)*sqrt(109.)/(10*x - 3*z);
		default:
			_error_("FS analytical solution"<<testid<<" not implemented yet");
	}
}
/*}}}*/

