function plot_quiver(md,options,canvas,gl,node) {
	//PLOT_QUIVER - quiver plot with colors
	//
	//   Usage:
	//      plot_quiver(md,options,canvas,gl,node)
	//

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var colors = [];
	var rgbcolor = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var scale,zscale,surfacescale;
	
	//Process data and model
	var meshresults = processmesh(md,[],options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	var vx = md.initialization.vx; 
	var vy = md.initialization.vy; 
		
	if (!md.geometry.surface) {
		md.geometry.surface=NewArrayFill(md.mesh.x.length,0);
	}
	if (md.mesh.classname() == 'mesh3dsurface') {
		zscale = 1;
		surfacescale = options.getfieldvalue('heightscale',1);
	}
	else {
		if (md.geometry.surface) {
			z=md.geometry.surface;
		}	
		zscale = options.getfieldvalue('heightscale',1);
		surfacescale = 0;
	}
	//}}}

	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];

	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "colored";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale * zscale];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["drawMode"] = gl.LINES;
	node["useIndexBuffer"] = false;
	node["drawOrder"] = 0;
	node["maskEnabled"] = options.exist('mask');
	node["maskHeight"] = options.getfieldvalue('maskheight',150.0)*options.getfieldvalue('heightscale',1);
	node["maskColor"] = options.getfieldvalue('maskcolor',[0.0,0.0,1.0,1.0]);
				
	//some defaults:
	colors.itemSize = 4;

	//retrieve some options
	var linewidth=options.getfieldvalue('linewidth',1);
	var edgecolor=options.getfieldvalue('edgecolor',[0.0,0.0,0.0,1.0]); //have RGBColor switch with array color?
	//var edgecolor=options.getfieldvalue('edgecolor','black'); //have RGBColor switch with array color?

	//node plot {{{
	if (elements[0].length==6){ //prisms
	}
	else if (elements[0].length==4){ //tetras
	}
	else{ //2D triangular elements
		vertices.itemSize = 3;
		var xyz = vec3.create();
		var direction = vec3.create();
		var vertex = vec3.create();
		var magnitude;
		var color = edgecolor;
		for(var i = 0; i < x.length; i++){
			//Check for NaN values and remove from indices array as necessary, but preserve vertex array spacing
			if (isNaN(x[i]) || isNaN(y[i]) || isNaN(z[i])) continue;
			//Scale vertices
			xyz1 = vec3.fromValues(x[i], y[i], z[i]);
			magnitude = vec3.length(xyz1) + md.geometry.surface[i] * surfacescale;
			vec3.normalize(direction, xyz1);
			vec3.scale(vertex, direction, magnitude);
			vertices.push.apply(vertices, vertex);
			
			xyz2 = vec3.fromValues(vx[i], vy[i], 0.0);
			magnitude = 100.0; //mesh resolution
			vec3.normalize(direction, xyz2);
			vec3.scale(direction, direction, magnitude);
			vec3.add(vertex, direction, vertex);
			vertices.push.apply(vertices, vertex);
			
			colors.push.apply(colors, color);
			colors.push.apply(colors, color);
		}
	}
	//}}}

	/*Initalize buffers: */
	node["arrays"] = [vertices, colors];
	node["buffers"] = initBuffers(gl, node["arrays"]);
	if (canvas.requestDrawing)	draw(gl,options,canvas);
}
