function plot_mesh(md,options,canvas,gl,node) {
	//   Usage:
	//      plot_mesh(md,options,canvas,gl);
	//
	//   See also: PLOTMODEL

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var colors = [];
	var nanindices = {};
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var scale,zscale,surfacescale;
	
	//Process data and model
	var meshresults = processmesh(md,[],options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
		
	if (!md.geometry.surface) {
		md.geometry.surface=NewArrayFill(md.mesh.x.length,0);
	}
	if (md.mesh.classname() == 'mesh3dsurface') {
		zscale = 1;
		surfacescale = options.getfieldvalue('heightscale',1);
	}
	else {
		if (md.geometry.surface) {
			z=md.geometry.surface;
		}	
		zscale = options.getfieldvalue('heightscale',1);
		surfacescale = 0;
	}
	//}}}

	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];

	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "colored";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale * zscale];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["drawMode"] = gl.LINES;
	node["drawOrder"] = 0;
	node["maskEnabled"] = options.exist('mask');
	node["maskHeight"] = options.getfieldvalue('maskheight',150.0)*options.getfieldvalue('heightscale',1);
	node["maskColor"] = options.getfieldvalue('maskcolor',[0.0,0.0,1.0,1.0]);
				
	//some defaults:
	colors.itemSize = 4;

	//retrieve some options
	var linewidth=options.getfieldvalue('linewidth',1);
	var edgecolor=options.getfieldvalue('edgecolor','black');

	//node plot {{{
	if (elements[0].length==6){ //prisms
	}
	else if (elements[0].length==4){ //tetras
	}
	else{ //2D triangular elements
		vertices.itemSize = 3;
		var xyz = vec3.create();
		var direction = vec3.create();
		var vertex = vec3.create();
		var magnitude;
		var color = [0.0, 0.0, 0.0, 1.0];	
						x[0] = NaN;
		x[1] = NaN;
		x[2] = NaN;
		x[3] = NaN;
		x[4] = NaN;
		x[5] = NaN;
		x[6] = NaN;
		x[7] = NaN;
		x[8] = NaN;
		x[9] = NaN;
		x[10] = NaN;
		x[11] = NaN;
		x[12] = NaN;
		x[13] = NaN;
		x[14] = NaN;
		x[15] = NaN;
		x[16] = NaN;
		x[17] = NaN;
		x[18] = NaN;
		x[19] = NaN;
		x[20] = NaN;
		x[21] = NaN;
		x[22] = NaN;
		x[23] = NaN;
		x[24] = NaN;
		x[25] = NaN;
		x[26] = NaN;
		x[27] = NaN;
		x[28] = NaN;
		x[29] = NaN;
		x[30] = NaN;
		x[31] = NaN;
		x[32] = NaN;
		x[33] = NaN;
		x[34] = NaN;
		x[35] = NaN;
		x[36] = NaN;
		x[37] = NaN;
		x[38] = NaN;
		x[39] = NaN;
		x[310] = NaN;
		x[311] = NaN;
		x[312] = NaN;
		x[313] = NaN;
		x[314] = NaN;
		x[315] = NaN;
		x[316] = NaN;
		x[317] = NaN;
		x[318] = NaN;
		x[319] = NaN;
		x[320] = NaN;
		x[321] = NaN;
		x[322] = NaN;
		x[323] = NaN;
		x[324] = NaN;
		x[325] = NaN;
		x[326] = NaN;
		x[327] = NaN;
		x[328] = NaN;
		x[329] = NaN;	
		for(var i = 0; i < x.length; i++){
			//Check for NaN values and remove from indices array as necessary, but preserve vertex array spacing
			if (isNaN(x[i]) || isNaN(y[i]) || isNaN(z[i])) {
				nanindices[i] = i;
				vertices.push.apply(vertices, vertex);
				continue;
			}
			//Scale vertices
			//Scale vertices
			xyz = vec3.fromValues(x[i], y[i], z[i]);
			magnitude = vec3.length(xyz) + md.geometry.surface[i] * surfacescale;
			vec3.normalize(direction, xyz);
			vec3.scale(vertex, direction, magnitude);
			vertices.push.apply(vertices, vertex);

			colors.push.apply(colors, color);
		}
		
		//linearize the elements array: 
		var element;
		for(var i = 0; i < elements.length; i++){
			element = [elements[i][0] - 1, elements[i][1] - 1, elements[i][2] - 1];
			if (element[0] in nanindices || element[1] in nanindices || element[2] in nanindices) continue;
			indices = indices.concat([element[0], element[1], element[1], element[2], element[2], element[0]]);
		}
		indices.itemSize = 1;
	}
	//}}}

	/*Initalize buffers: */
	node["arrays"] = [vertices, colors, indices];
	node["buffers"] = initBuffers(gl, node["arrays"]);
	if (canvas.requestDrawing)	draw(gl,options,canvas);
}
