function hostname=oshostname()
%OSHOSTNAME - Determine hostname, irrespective of os type
%
%   Usage:
%      hostname=oshostname();

% Find computer name from environment
if ispc
	hostname = getenv('COMPUTERNAME');
else
	hostname = getenv('HOSTNAME');
end

% Take out minus signs
hostname = strrep(hostname,'-','');

% Check that machine name is not empty
if isempty(hostname),
	error('Cannot determine machine name');
end
