function plot_unit(md,data,options,canvas,gl,node) {
	//PLOT_UNIT - unit plot, display data
	//
	//   Usage:
	//      plot_unit(md,data,options,canvas,gl);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var texcoords = [];
	var rgbcolor = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var datamin,datamax,datadelta;
	var scale,zscale,surfacescale;

	//Process data and model
	var meshresults = processmesh(md,data,options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	
	var	dataresults = processdata(md,data,options);
	var	data2 = dataresults[0]; 
	var	datatype = dataresults[1];

	if (!md.geometry.surface) {
		md.geometry.surface=NewArrayFill(md.mesh.x.length,0);
	}
	if (md.mesh.classname() == 'mesh3dsurface') {
		zscale = 1;
		surfacescale = options.getfieldvalue('heightscale',1);
	}
	else {
		if (md.geometry.surface) {
			z=md.geometry.surface;
		}	
		zscale = options.getfieldvalue('heightscale',1);
		surfacescale = 0;
	}
	//}}}

	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];
	var caxis;
	
	//Compute scaling: 
	scale = 1 / (xmax - xmin);
	node["shaderName"] = "unlit_textured";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale * zscale];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["alpha"] = options.getfieldvalue('alpha',1.0);
	node["drawOrder"] = 0;
	node["maskEnabled"] = options.getfieldvalue('innermask','off') == 'on';
	node["maskHeight"] = options.getfieldvalue('innermaskheight',150.0);
	node["maskColor"] = options.getfieldvalue('innermaskcolor',[0.0,0.0,1.0,1.0]);
	node["enabled"] = options.getfieldvalue('nodata','off') == 'off';
	
	switch(datatype){
		//element plot {{{
		case 1:
			pos=ArrayFindNot(data,NaN); //needed for element on water
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){ //tetras
			}
			else{ //2D triangular elements
			}
			break;
		//}}}
		//node plot {{{
		case 2:
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){ //tetras
			}
			else{ //triangular elements	
				caxis = options.getfieldvalue('caxis',[ArrayMin(data),ArrayMax(data)]);
				datamin = caxis[0];
				datamax = caxis[1];
				datadelta = datamax - datamin;

				vertices.itemSize = 3;
				texcoords.itemSize = 2;
				
				var xyz = vec3.create();
				var direction = vec3.create();
				var vertex = vec3.create();
				var magnitude;
	
				for(var i = 0; i < x.length; i++){
					xyz = vec3.fromValues(x[i], y[i], z[i]);
					magnitude = vec3.length(xyz) + md.geometry.surface[i] * surfacescale;
					vec3.normalize(direction, xyz);
					vec3.scale(vertex, direction, magnitude);
					vertices.push.apply(vertices, vertex);

					texcoords.push.apply(texcoords, [0.5, (data[i] - datamin) / datadelta]);
				}

				//linearize the elements array: 
				indices = indices.concat.apply(indices, elements); 
				indices.itemSize = 1;
				for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.

			}
			//Initalize buffers
			node["arrays"] = [vertices, texcoords, indices];
			node["buffers"] = initBuffers(gl,node["arrays"]);
			break;
		//}}}
		//quiver plot {{{
		case 3:
			if (is2d){
				//plot_quiver(x,y,data(:,1),data(:,2),options);
			}
			else{
				//plot_quiver3(x,y,z,data(:,1),data(:,2),data(:,3),options);
			}
			break;
		//}}}
		//node transient plot {{{
		case 5:
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){//tetras
			}
			else{ //triangular elements
				vertices.itemSize = 3;
				
				var xyz = vec3.create();
				var direction = vec3.create();
				var vertex = vec3.create();
				var magnitude;

				for(var i = 0; i < x.length; i++){
					xyz = vec3.fromValues(x[i], y[i], z[i]);
					magnitude = vec3.length(xyz) + md.geometry.surface[i] * surfacescale;
					vec3.normalize(direction, xyz);
					vec3.scale(vertex, direction, magnitude);
					vertices.push.apply(vertices, vertex);
				}	
				
				//Transpose data to obtain column addressable data matrix
				data = data[0].map(function(col, i) { 
					return data.map(function(row) { 
						return row[i]
					})
				});
				
				for(var i = 0; i < data.length-1; i++){
					//Prevent evaluation of datasubarray min/max if caxis exists
					if (options.exist('caxis')) {
						caxis = options.getfieldvalue('caxis');
					}
					else {
						caxis = [ArrayMin(data[i]),ArrayMax(data[i].slice(0,-1))];
					}
					datamin = caxis[0];
					datamax = caxis[1];
					datadelta = datamax - datamin;

					//Precalculate arrays for each datasubarray
					texcoords[i] = [];
					texcoords[i].itemSize = 2;
					for(var j = 0; j < x.length; j++){
						texcoords[i][texcoords[i].length] = 0.5;
						texcoords[i][texcoords[i].length] = (data[i][j] - datamin) / datadelta;
					}
				}
				
				//linearize the elements array: 
				indices = indices.concat.apply(indices, elements); 
				indices.itemSize = 1;
				for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.
				
				//Initialize movie loop
				node["movieInterval"] = 1000 / options.getfieldvalue('moviefps',5);
				node["movieLength"] = data.length-1;
				node["movieFrame"] = 0;
				node["movieHandler"] = function () {
						if (canvas["moviePlay"]) {
							node["movieFrame"] = canvas["movieFrame"];
							if (canvas["movieIncrement"]) {
								if (canvas["movieReverse"]) {
									node["movieFrame"] = (((node["movieFrame"] - 1) % node["movieLength"]) + node["movieLength"]) % node["movieLength"]; //Handle negative modulus
								}
								else {
									node["movieFrame"] = (((node["movieFrame"] + 1) % node["movieLength"]) + node["movieLength"]) % node["movieLength"]; //Handle negative modulus
								}
							}
							if (canvas["timeLabel"]) {
								canvas["timeLabel"].html(String(node["movieFrame"]) + "/" +  String(node["movieLength"] - 1));
							}
							if (canvas["progressBar"]) {
								canvas["progressBar"].slider("value", node["movieFrame"]);
							}
							var array = [node["arrays"][0],node["arrays"][1][node["movieFrame"]],node["arrays"][2]];
							node["buffers"] = initBuffers(gl,array);
							canvas["movieFrame"] = node["movieFrame"];
						}
						setTimeout(node["movieHandler"], node["movieInterval"]);
					};
				setTimeout(node["movieHandler"], node["movieInterval"]);
				if (canvas["progressBar"]) {
					canvas["movieFrame"] = 0;
					canvas["progressBar"].slider("value", 0);
					canvas["progressBar"].slider("option", {max: node["movieLength"]-1});
				}
			}
			
			//Initalize buffers
			node["arrays"] = [vertices, texcoords, indices];
			node["buffers"] = initBuffers(gl,[node["arrays"][0],node["arrays"][1][0],node["arrays"][2]]);
			break;
		//}}}
		default:
			throw Error(sprintf("%s%i%s\n",'case ',datatype,' not supported'));
	}
	if (canvas.requestDrawing) draw(gl,options,canvas);
}
