function plot_overlay(md,data,options,canvas,gl,node){
	//PLOT_OVERLAY - Function for plotting a georeferenced image.  
	//This function is called from within the plotmodel code.
	//
	//   Usage:
	//      plot_overlay(md,data,options,canvas,gl,node);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var texcoords = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var scale,zscale,surfacescale;

	//Process data and model
	var meshresults = processmesh(md,data,options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];

	if (!md.geometry.surface) {
		md.geometry.surface=NewArrayFill(md.mesh.x.length,0);
	}
	if (md.mesh.classname() == 'mesh3dsurface') {
		zscale = 1;
		surfacescale = options.getfieldvalue('heightscale',1);
	}
	else {
		if (md.geometry.surface) {
			z=md.geometry.surface;
		}	
		zscale = options.getfieldvalue('heightscale',1);
		surfacescale = 0;
	}
	//}}}
	
	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];
		
	//Compute scaling: 
	scale = 1 / (xmax - xmin);
	node["shaderName"] = "unlit_textured";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale * zscale];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["texture"] = initTexture(gl,options.getfieldvalue('image'));
	node["alpha"] = options.getfieldvalue('outeralpha',1.0);
	node["drawOrder"] = 1;
	node["maskEnabled"] = options.getfieldvalue('outermask','off') == 'on';
	node["maskHeight"] = options.getfieldvalue('outermaskheight',150.0);
	node["maskColor"] = options.getfieldvalue('outermaskcolor',[0.0,0.0,1.0,1.0]);
				
	//some defaults:
	texcoords.itemSize = 2;
	vertices.itemSize = 3;
	
	//Handle outer radaroverlay
	if (md.radaroverlay.outerx) {
		var newelements = [];
		for (var i = 0; i < md.radaroverlay.outerindex.length; i++) {
			newelements.push([md.radaroverlay.outerindex[i][0] + x.length, md.radaroverlay.outerindex[i][1] + y.length, md.radaroverlay.outerindex[i][2] + z.length]);
		}
		x = [].concat(x, md.radaroverlay.outerx);
		y = [].concat(y, md.radaroverlay.outery);
		z = [].concat(z, md.radaroverlay.outerheight);
		elements = [].concat(elements, newelements);
		
		//Reclaculate bounds based on otuer radaroverlay
		modelxlim = [ArrayMin(x),ArrayMax(x)];
		modelylim = [ArrayMin(y),ArrayMax(y)];
		modelzlim = [ArrayMin(z),ArrayMax(z)];
		xmin = xlim[0];
		xmax = xlim[1];
		ymin = ylim[0];
		ymax = ylim[1];
		zmin = zlim[0];
		zmax = zlim[1];
		
		node["translation"] = [node["translation"][0], node["translation"][1], (zmax) / (-1 / scale)];
	}
	
	var xrange = modelxlim[1] - modelxlim[0];
	var yrange = modelylim[1] - modelylim[0];
	
	var xyz = vec3.create();
	var direction = vec3.create();
	var vertex = vec3.create();
	var magnitude;

	//generate mesh:
	for(var i = 0; i < x.length; i++){
		xyz = vec3.fromValues(x[i], y[i], z[i]);
		magnitude = vec3.length(xyz);
		vec3.normalize(direction, xyz);
		vec3.scale(vertex, direction, magnitude);
		vertices.push.apply(vertices, vertex);

		texcoords.push.apply(texcoords, [(x[i] - modelxlim[0]) / xrange, (y[i] - modelylim[0]) / yrange]);
	}

	//linearize the elements array: 
	indices = indices.concat.apply(indices, elements); 
	indices.itemSize = 1;
	for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.
	
	/*Initalize buffers: */
	node["arrays"] = [vertices, texcoords, indices];
	node["buffers"] = initBuffers(gl,node["arrays"]);
	if (canvas.requestDrawing)	draw(gl,options,canvas);
}
