function fields=testsgetfields(mdtype,analysis),
%TESTSGETFIELDS - build the fields to be checked from a analysis
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input analysis 'prognostic', it will output 'cielo'
%
%   Usage:
%      fields=testsgetfields(mdtype,analysis)
%
%   Example:
%      fields=testsgetfields(md.type,'diagnostic')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

if strcmpi(analysis,'diagnostic'),
	if md.control_analysis,
		fields={'diagnostic.vel','diagnostic.J','diagnostic.parameter'};
	else
		if strcmpi(mdtype,'3d')
			fields={'diagnostic.vy','diagnostic.vz'};
		else
			fields={'diagnostic.vel'};
		end
	end

elseif strcmpi(analysis,'thermal_steady'),
	fields={'thermal.temperature','thermal.melting'};

elseif strcmpi(analysis,'thermal_transient'),
	fields={'thermal(end).temperature','thermal(end).melting'};

elseif strcmpi(analysis,'prognostic'),
	fields={'prognostic.thickness'};

elseif strcmpi(analysis,'transient'), 
	if strcmpi(mdtype,'3d')
		fields={'transient(end).vel','transient(end).pressure','transient(end).temperature','transient(end).melting','transient(end).thickness','transient(end).surface','transient(end).bed'};
	else
		fields={'transient(end).vel','transient(end).thickness','transient(end).surface','transient(end).bed'};
	end

elseif strcmpi(analysis,'steadystate'), 
	if md.control_analysis,
		fields={'steadystate.vel','steadystate.J','steadystate.parameter'};
	else
		fields={'steadystate.vel','steadystate.pressure','steadystate.temperature'};
	end

elseif strncmpi(analysis,'diagnostic_',11),
	fields={'diagnostic.vel','diagnostic.J','diagnostic.parameter'};

elseif strncmpi(analysis,'steadystate_',12),
	fields={'steadystate.vel','steadystate.J','steadystate.parameter'};

else
	error(['testsgetfields error message: solution '  analysis ' not supported yet']);
end
