function slider(){
	
	//Convert arguments to options
	var args = Array.prototype.slice.call(arguments);
	var  options = new pairoptions(args.slice());

	//Recover option values:
	var value = options.getfieldvalue('value',0);
	var callback = options.getfieldvalue('callback',function(){});
	var name = options.getfieldvalue('name','');
	var min = options.getfieldvalue('min',0.6*value);
	var max = options.getfieldvalue('max',1.4*value);
	var width = options.getfieldvalue('width','auto');
	var height = options.getfieldvalue('height',32);
	var message = options.getfieldvalue('message','');
	var startmessage = options.getfieldvalue('startmessage',message);
	var middlemessage = options.getfieldvalue('middlemessage',message);
	var endmessage = options.getfieldvalue('endmessage',message);
	var color = options.getfieldvalue('color','#bbbbbb');
	var precision = options.getfieldvalue('precision',3);
	var step = options.getfieldvalue('step',1);
	var slidersdiv = options.getfieldvalue('slidersdiv','slidersdiv');

	$('#'+slidersdiv).css({width:width});
	$('<div class="slider'+name+'"></div>').appendTo('#'+slidersdiv);
	$('<div class="info'+name+'">'+startmessage[0]+value.toString()+startmessage[1]+'</div>').appendTo('#'+slidersdiv);
	var info=$('.info'+name);
	$('.slider'+name).slider({
		range:'min',
		value:value,
		min:min,
		max:max,
		step:step,
		slide:function(event,ui){
			moveSlide(event,ui,info,middlemessage,precision);
		},
		stop:function(event,ui){
			stopSlide(event,ui,info,callback,middlemessage,endmessage,precision);
		},
	});
	$('.ui-slider').css({
		width:'auto',
		height:height,
		background:color,
		margin:'8px'
	});
	$('.ui-slider-handle').css({
		background:color,
		height:parseInt(height)+8
	});
	$('.ui-slider-range').css({
		background:color
	});

}

function moveSlide(event,ui,info,middlemessage,precision){
	var val=ui.value;
	info.text(middlemessage[0]+val.toPrecision(precision).toString()+middlemessage[1]);
}

function stopSlide(event,ui,info,functionvalue,middlemessage,endmessage,precision){
	var val=ui.value;
	info.text(middlemessage[0]+val.toPrecision(precision).toString()+middlemessage[1]);
	functionvalue(val);
	info.text(endmessage[0]+val.toPrecision(precision).toString()+endmessage[1]);
}
