function result=testschecksolution(mdtype,solution),
%TESTSCHECKSOLUTION - check the solution requested 
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   to be sure that the solution resquested is consistent with the model type.
%   It returns 1 of the solution is consistent, 0 else.
%   The solution must be a string.
%
%   Usage:
%      result=testschecksolution(mdtype,solution)
%
%   Example:
%      result=testschecksolution(md.type,'prognostic')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE, TESTSCHECKMISFIT

if strcmpi(mdtype,'2d')
	result=ismember({solution},{'diagnostic','prognostic','transient','diagnostic_absolute','diagnostic_relative','diagnostic_logarithmic'});
elseif strcmpi(mdtype,'3d')
	result=ismember({solution},{'diagnostic','prognostic','transient','thermal_steady','thermal_transient','steadystate','diagnostic_absolute','diagnostic_relative','diagnostic_logarithmic','steadystate_absolute'});
end
