/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"

void CreateParametersControl(DataSet* parameters,Model* model,ConstDataHandle model_handle,int* pcount){
	
	int i;
	
	Param*   param = NULL;
	int      count;
	int      analysis_type;
	int      numberofdofspernode;

	double* fit=NULL;
	double* optscal=NULL;
	double* maxiter=NULL; 
	Vec     control_parameter=NULL;
	Vec     vx_obs=NULL;
	Vec     vy_obs=NULL;

	/*Get counter : */
	count=*pcount;
	
	/*control_type: */
	count++;
	param= new Param(count,"control_type",STRING);
	param->SetString(model->control_type);
	parameters->AddObject(param);


	/*nsteps: */
	count++;
	param= new Param(count,"nsteps",INTEGER);
	param->SetInteger(model->nsteps);
	parameters->AddObject(param);

	/*tolx: */
	count++;
	param= new Param(count,"tolx",DOUBLE);
	param->SetDouble(model->tolx);
	parameters->AddObject(param);

	/*mincontrolconstraint: */
	count++;
	param= new Param(count,"mincontrolconstraint",DOUBLE);
	param->SetDouble(model->mincontrolconstraint);
	parameters->AddObject(param);

	/*maxcontrolconstraint: */
	count++;
	param= new Param(count,"maxcontrolconstraint",DOUBLE);
	param->SetDouble(model->maxcontrolconstraint);
	parameters->AddObject(param);
	
	/*epsvel: */
	count++;
	param= new Param(count,"epsvel",DOUBLE);
	param->SetDouble(model->epsvel);
	parameters->AddObject(param);
	
	/*meanvel: */
	count++;
	param= new Param(count,"meanvel",DOUBLE);
	param->SetDouble(model->meanvel);
	parameters->AddObject(param);

	/*Now, recover fit, optscal and maxiter as vectors: */
	ModelFetchData((void**)&model->fit,NULL,NULL,model_handle,"fit","Matrix","Mat");
	ModelFetchData((void**)&model->optscal,NULL,NULL,model_handle,"optscal","Matrix","Mat");
	ModelFetchData((void**)&model->maxiter,NULL,NULL,model_handle,"maxiter","Matrix","Mat");

	count++;
	param= new Param(count,"fit",DOUBLEVEC);
	param->SetDoubleVec(model->fit,model->nsteps);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"optscal",DOUBLEVEC);
	param->SetDoubleVec(model->optscal,model->nsteps);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"maxiter",DOUBLEVEC);
	param->SetDoubleVec(model->maxiter,model->nsteps);
	parameters->AddObject(param);

	xfree((void**)&model->fit);
	xfree((void**)&model->optscal);
	xfree((void**)&model->maxiter);

	/*Get vx_obs, vy_obs, and the parameter value: */
	ModelFetchData((void**)&vx_obs,NULL,NULL,model_handle,"vx_obs","Vector",NULL);
	ModelFetchData((void**)&vy_obs,NULL,NULL,model_handle,"vy_obs","Vector",NULL);
	ModelFetchData((void**)&control_parameter,NULL,NULL,model_handle,model->control_type,"Vector",NULL);

	VecScale(vx_obs,1.0/model->yts);
	VecScale(vy_obs,1.0/model->yts);

	count++;
	param= new Param(count,"vx_obs",PETSCVEC);
	param->SetVec(vx_obs);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"vy_obs",PETSCVEC);
	param->SetVec(vy_obs);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"control_parameter",PETSCVEC);
	param->SetVec(control_parameter);
	parameters->AddObject(param);
	
	VecFree(&vx_obs);
	VecFree(&vy_obs);
	VecFree(&control_parameter);


	/*Assign output pointer: */
	*pcount=count;
}

	
