//GENERIC class definition
//
//   Usage:
//      generic=new generic();

function generic (){
	//properties 
	// {{{
	var args = Array.prototype.slice.call(arguments);
	var options = new pairoptions(args.slice(0,args.length));

	this.url=options.getfieldvalue('url','');
	this.np=options.getfieldvalue('np',3);
	this.codepath=options.getfieldvalue('codepath','issmdir/bin');
	this.executionpath=options.getfieldvalue('executionpath','issmdir/execution');
	//}}}
	//methods
	this.disp= function(){// {{{
		console.log(sprintf('   generic class echo:'));
		console.log(sprintf('    url: "%s"',this.url));
		console.log(sprintf('    np: %i',this.np));
		console.log(sprintf('    codepath: "%s"',this.codepath));
		console.log(sprintf('    executionpath: "%s"',this.executionpath));
	}// }}}
	this.classname= function(){// {{{
		return "generic";
	}// }}}
	this.checkconsistency = function (md,solution,analyses) { //{{{
		if (cluster.np<1){
			md.checkmessage('number of processors should be at least 1');
		}
		if (isNaN(cluster.np)){
			md.checkmessage('number of processors should not be NaN!');
		}
	} //}}}
	this.BuildQueueScript = function (cluster,dirname,modelname,solution,io_gather,isvalgrind,isgprof,isdakota) { // {{{

			//write queuing script 
			//what is the executable being called? 
			executable='issm.exe';

			fid=fopen(modelname+'.queue','w');
			fprintf(fid,'#!%s\n',cluster.shell);
			fprintf(fid,'mpiexec -np %i %s/%s %s %s %s 2> %s.errlog >%s.outlog ',cluster.np,cluster.codepath,executable,EnumToString(solution),cluster.executionpath+'/'+dirname,modelname,modelname,modelname);					
			fclose(fid);
	} //{{{
	this.UploadAndRun = function (md,callbackfunction,fid,toolkitsstring,solutionstring,name,runtimename) { //{{{

		var oReq = new XMLHttpRequest();
		oReq.open("POST", this.url, true);
		oReq.responseType = 'arraybuffer';

		oReq.onload = function (oEvent) {
			var returnBuffer = new Uint8Array(oReq.response.slice());
			var returnBuffer_size=returnBuffer.byteLength;
			md.results= parseresultsfrombuffer(returnBuffer,returnBuffer_size);
			callbackfunction();
		};

		var runtimenamebuffer = this.str2ab(runtimename);
		var runtimenamelength = new Uint32Array(1);
		runtimenamelength[0] = runtimenamebuffer.byteLength;
		
		var namebuffer = this.str2ab(name);
		var namelength = new Uint32Array(1);
		namelength[0] = namebuffer.byteLength;
		
		var toolkitsbuffer = this.str2ab(toolkitsstring);
		var toolkitslength = new Uint32Array(1);
		toolkitslength[0] = toolkitsbuffer.byteLength;
		
		var solutionbuffer = this.str2ab(solutionstring);
		var solutionlength = new Uint32Array(1);
		solutionlength[0] = solutionbuffer.byteLength;
		
		var binbuffer = new Uint16Array(fid.buffer);
		var binlength = new Uint32Array(1);
		binlength[0] = binbuffer.byteLength;
		
		var data = new Blob([runtimenamelength,runtimenamebuffer,namelength,namebuffer,toolkitslength,toolkitsbuffer,solutionlength,solutionbuffer,binlength,binbuffer]);
		//console.log([runtimenamelength,runtimenamebuffer,namelength,namebuffer,toolkitslength,toolkitsbuffer,solutionlength,solutionbuffer,binlength,binbuffer]);
		oReq.send(data);
		return;

	} //}}}
	this.ab2str = function(buf) {
		return String.fromCharCode.apply(null, new Uint16Array(buf));
	}
	this.str2ab = function(str) {
		var buf = new Uint8Array(str.length);
		for (var i=0, strLen=str.length; i < strLen; i++) {
			buf[i] = str.charCodeAt(i);
		}
		return buf;
	}
}
