function plot_unit(md,data,options,canvas,gl,node) {
	//PLOT_UNIT - unit plot, display data
	//
	//   Usage:
	//      plot_unit(md,data,options,canvas,gl);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var texcoords = [];
	var rgbcolor = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var datamin,datamax,datadelta;
	var scale;

	//Process data and model
	var meshresults = processmesh(md,data,options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	var is3d = md.mesh.classname() == 'mesh3dsurface'; //use meshresults once behvaior can be verified
	
	var	dataresults = processdata(md,data,options);
	var	data2 = dataresults[0]; 
	var	datatype = dataresults[1];
	
	if (!is3d && md.geometry.surface) {
		z = md.geometry.surface;
	}
	//}}}

	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];
	var caxis;

	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "unlit_textured";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale*options.getfieldvalue('heightscale',1)];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["alpha"] = options.getfieldvalue('alpha',1.0);
	node["overlay"] = options.getfieldvalue('overlay','off') == 'on';
	node["drawOrder"] = 0;
	node["maskEnabled"] = options.getfieldvalue('innermask','off') == 'on';
	node["maskHeight"] = options.getfieldvalue('innermaskheight',150.0);
	node["maskColor"] = options.getfieldvalue('innermaskcolor',[0.0,0.0,1.0,1.0]);
	node["enabled"] = options.getfieldvalue('nodata','off') == 'off';
	
	switch(datatype){
		//element plot {{{
		case 1:
			pos=ArrayFindNot(data,NaN); //needed for element on water
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){ //tetras
			}
			else{ //2D triangular elements
			}
			break;
		//}}}
		//node plot {{{
		case 2:
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){ //tetras
			}
			else{ //triangular elements	
				caxis = options.getfieldvalue('caxis',[ArrayMin(data),ArrayMax(data)]);
				datamin = caxis[0];
				datamax = caxis[1];
				datadelta = datamax - datamin;
				console.log(datadelta, caxis);

				vertices.itemSize = 3;
				texcoords.itemSize = 2;
				//var height = vec3.create();
				//var heightscale = options.getfieldvalue('heightscale',1);
				for(var i = 0; i < x.length; i++){
					//vec3.normalize(height, vec3.fromValues(x[i], y[i], z[i])); //fix to use normalized earth radius instead of radius+ height
					//vec3.scale(height, height, heightscale);
					vertices[vertices.length] = x[i];
					vertices[vertices.length] = y[i];
					vertices[vertices.length] = z[i];

					texcoords[texcoords.length] = 0.5;
					texcoords[texcoords.length] = (data[i] - datamin) / datadelta;
				}

				//linearize the elements array: 
				indices = indices.concat.apply(indices, elements); 
				indices.itemSize = 1;
				for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.

			}
			//Initalize buffers
			node["arrays"] = [vertices, texcoords, indices];
			node["buffers"] = initBuffers(gl,node["arrays"]);
			break;
		//}}}
		//quiver plot {{{
		case 3:
			if (is2d){
				//plot_quiver(x,y,data(:,1),data(:,2),options);
			}
			else{
				//plot_quiver3(x,y,z,data(:,1),data(:,2),data(:,3),options);
			}
			break;
		//}}}
		//node transient plot {{{
		case 5:
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){//tetras
			}
			else{ //triangular elements
				vertices.itemSize = 3;
				for(var i = 0; i < x.length; i++){
					vertices[vertices.length] = x[i];
					vertices[vertices.length] = y[i];
					vertices[vertices.length] = z[i];
				}	
				
				//Transpose data to obtain column addressable data matrix
				data = data[0].map(function(col, i) { 
					return data.map(function(row) { 
						return row[i]
					})
				});
				
				for(var i = 0; i < data.length-1; i++){
					//Prevent evaluation of datasubarray min/max if caxis exists
					if (options.exist('caxis')) {
						caxis = options.getfieldvalue('caxis');
					}
					else {
						caxis = [ArrayMin(data[i].slice(0,-1)),ArrayMax(data[i].slice(0,-1))];
					}
					datamin = caxis[0];
					datamax = caxis[1];
					datadelta = datamax - datamin;

					//Precalculate arrays for each datasubarray
					texcoords[i] = [];
					texcoords[i].itemSize = 2;
					for(var j = 0; j < x.length; j++){
						texcoords[i][texcoords[i].length] = 0.5;
						texcoords[i][texcoords[i].length] = (data[i][j] - datamin) / datadelta;
					}
				}
				
				//linearize the elements array: 
				indices = indices.concat.apply(indices, elements); 
				indices.itemSize = 1;
				for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.
				
				//Initialize movie loop
				node["movieInterval"] = 1000 / options.getfieldvalue('moviefps',5);
				node["movieLength"] = data.length-1;
				node["movieFrame"] = 0;
				node["movieHandler"] = function () {
						node["movieFrame"] = (node["movieFrame"] + 1) % (node["movieLength"]);
						var array = [node["arrays"][0],node["arrays"][1][node["movieFrame"]],node["arrays"][2]];
						node["buffers"] = initBuffers(gl,array);
						setTimeout(node["movieHandler"], node["movieInterval"]);
					};
				setTimeout(node["movieHandler"], node["movieInterval"]);
			}
			
			//Initalize buffers
			node["arrays"] = [vertices, texcoords, indices];
			node["buffers"] = initBuffers(gl,[node["arrays"][0],node["arrays"][1][0],node["arrays"][2]]);
			break;
		//}}}
		default:
			throw Error(sprintf("%s%i%s\n",'case ',datatype,' not supported'));
	}
}
