function plot_mesh(md,options,canvas,gl,node) {
	//   Usage:
	//      plot_mesh(md,options,canvas,gl);
	//
	//   See also: PLOTMODEL

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var colors = [];
	var rgbcolor = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;
	var scale;
	
	//Process data and model
	var meshresults = processmesh(md,[],options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	var is3d = md.mesh.classname() == 'mesh3dsurface'; //use meshresults once behvaior can be verified
	
	if (!is3d && md.geometry.surface) {
		z = md.geometry.surface;
	}
	//}}}

	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];

	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "colored";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale*options.getfieldvalue('heightscale',1)];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (-2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["drawMode"] = gl.LINES;
	node["overlay"] = false;
	node["drawOrder"] = 0;
	node["maskEnabled"] = options.exist('mask');
	node["maskHeight"] = options.getfieldvalue('maskheight',150.0)*options.getfieldvalue('heightscale',1);
	node["maskColor"] = options.getfieldvalue('maskcolor',[0.0,0.0,1.0,1.0]);
				
	//some defaults:
	colors.itemSize = 4;

	//retrieve some options
	var linewidth=options.getfieldvalue('linewidth',1);
	var edgecolor=options.getfieldvalue('edgecolor','black');

	//node plot {{{
	if (elements[0].length==6){ //prisms
	}
	else if (elements[0].length==4){ //tetras
	}
	else{ //2D triangular elements
		vertices.itemSize = 3;
		for(var i = 0; i < x.length; i++){
			vertices[vertices.length] = x[i];
			vertices[vertices.length] = y[i];
			vertices[vertices.length] = z[i];

			rgbcolor = [0.0, 0.0, 0.0];
			colors[colors.length] = rgbcolor[0];
			colors[colors.length] = rgbcolor[1];
			colors[colors.length] = rgbcolor[2];
			colors[colors.length] = 1.0;
		}

		//linearize the elements array: 
		for(var i = 0; i < elements.length; i++){
			//convert tris to line edges; generates more edges than necessary, should optimize using node connectivity
			//matlab indices from 1, so decrement indices.
			indices[indices.length] = elements[i][0] - 1;
			indices[indices.length] = elements[i][1] - 1;
			indices[indices.length] = elements[i][1] - 1;
			indices[indices.length] = elements[i][2] - 1;
			indices[indices.length] = elements[i][2] - 1;
			indices[indices.length] = elements[i][0] - 1;
		}
		indices.itemSize = 1;
	}
	//}}}

	/*Initalize buffers: */
	node["arrays"] = [vertices, colors, indices];
	node["buffers"] = initBuffers(gl, node["arrays"]);
}
