function plot_overlay(md,data,options,canvas,gl,node){
	//PLOT_OVERLAY - Function for plotting a georeferenced image.  
	//This function is called from within the plotmodel code.
	//
	//   Usage:
	//      plot_overlay(md,data,options,canvas,gl,node);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	//declare variables:  {{{
	var vertices = [];
	var indices = [];
	var texcoords = [];
	var xmin,xmax;
	var ymin,ymax;
	var zmin,zmax;

	//Process data and model
	var meshresults = processmesh(md,data,options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3]; 
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	var is3d = (md.mesh.classname() == 'mesh3dsurface');	//use is2d/isplanet once verified to work with mesh3dsurface
	
	if (!is3d && md.geometry.surface) {
		z = md.geometry.surface;
	}
	//}}}
	
	//Compute coordinates and data range:
	var modelxlim = [ArrayMin(x),ArrayMax(x)];
	var modelylim = [ArrayMin(y),ArrayMax(y)];
	var modelzlim = [ArrayMin(z),ArrayMax(z)];
	var xlim = options.getfieldvalue('xlim',modelxlim);
	var ylim = options.getfieldvalue('ylim',modelylim);
	var zlim = options.getfieldvalue('zlim',modelzlim);
	xmin = xlim[0];
	xmax = xlim[1];
	ymin = ylim[0];
	ymax = ylim[1];
	zmin = zlim[0];
	zmax = zlim[1];
		
	//Compute scaling: 
	var scale = 1 / (xmax - xmin);
	node["shaderName"] = "unlit_textured";
	node["shader"] = gl["shaders"][node["shaderName"]]["program"];
	node["scale"] = [scale, scale, scale*options.getfieldvalue('heightscale',1)];
	node["translation"] = [(xmin + xmax) / (-2 / scale), (ymin + ymax) / (-2 / scale), (zmin + zmax) / (2 / scale)];
	node["modelMatrix"] = recalculateModelMatrix(node);
	node["texture"] = initTexture(gl,options.getfieldvalue('image'));
	node["alpha"] = options.getfieldvalue('outeralpha',.9);
	node["overlay"] = false;
	node["drawOrder"] = 1;
	node["maskEnabled"] = options.getfieldvalue('outermask','off') == 'on';
	node["maskHeight"] = options.getfieldvalue('outermaskheight',150.0);
	node["maskColor"] = options.getfieldvalue('outermaskcolor',[0.0,0.0,1.0,1.0]);
				
	//some defaults:
	texcoords.itemSize = 2;
	vertices.itemSize = 3;
	
	//Handle outer radaroverlay
	if (md.radaroverlay.outerx) {
		var newelements = [];
		for (var i = 0; i < md.radaroverlay.outerindex.length; i++) {
			newelements.push([md.radaroverlay.outerindex[i][0] + x.length, md.radaroverlay.outerindex[i][1] + y.length, md.radaroverlay.outerindex[i][2] + z.length]);
		}
		x = [].concat(x, md.radaroverlay.outerx);
		y = [].concat(y, md.radaroverlay.outery);
		z = [].concat(z, md.radaroverlay.outerheight);
		elements = [].concat(elements, newelements);
		
		//Reclaculate bounds based on otuer radaroverlay
		modelxlim = [ArrayMin(x),ArrayMax(x)];
		modelylim = [ArrayMin(y),ArrayMax(y)];
		modelzlim = [ArrayMin(z),ArrayMax(z)];
		xmin = xlim[0];
		xmax = xlim[1];
		ymin = ylim[0];
		ymax = ylim[1];
		zmin = zlim[0];
		zmax = zlim[1];
		
		node["translation"] = [node["translation"][0], node["translation"][1], (zmax) / (-1 / scale)];
	}
	
	var xrange = modelxlim[1] - modelxlim[0];
	var yrange = modelylim[1] - modelylim[0];

	//generate mesh:
	for(var i = 0; i < x.length; i++){
		vertices[vertices.length] = x[i];
		vertices[vertices.length] = y[i];
		vertices[vertices.length] = z[i];

		texcoords[texcoords.length] = (x[i] - modelxlim[0]) / xrange;
		texcoords[texcoords.length] = (y[i] - modelylim[0]) / yrange;
	}

	//linearize the elements array: 
	indices = indices.concat.apply(indices, elements); 
	indices.itemSize = 1;
	for(var i=0;i<indices.length;i++)indices[i]--; //matlab indices from 1, so decrement.
	
	/*Initalize buffers: */
	node["arrays"] = [vertices, texcoords, indices];
	node["buffers"] = initBuffers(gl,node["arrays"]);
}