#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#version of petsc
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/petsc-//g'`

#Some cleanup
rm -rf install petsc-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  petsc-$version.tar.gz

#Move petsc to install directory
rm -rf install/*
mv petsc-$version/* install/
rm -rf petsc-$version

#Configure petsc
cd install
../configure.sh

#Compile petsc and install it
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
make install
