%Test Name: EarthSlr
%Earth Sea Level Rise test. Uses the mesh3dsurface geometry.

	%mesh earth: 
	md=model; 
	md.mesh=gmshplanet('radius',6.371012*10^3,'resolution',700); %500 km resolution mesh
	
	%parameterize slr solution:
	%slr loading:  {{{
	md.slr.deltathickness=zeros(md.mesh.numberofvertices,1);
	md.slr.sealevel=zeros(md.mesh.numberofvertices,1);
	%antarctica
	pos=find(md.mesh.lat <-80);
	md.slr.deltathickness(pos)=-100;
	%greenlnd 
	pos=find(md.mesh.lat > 70 &  md.mesh.lat < 80 & md.mesh.long>-60 & md.mesh.long<-30);
	md.slr.deltathickness(pos)=-100;
	
	%elastic loading from love numbers: 
	love = dlmread('../Data/love_numbers_10k.txt');
	nlov=101;
	md.slr.love_h = love(1:nlov,2);  % radial displacement (height) 
	md.slr.love_k = love(1:nlov,3);  % gravitational potential (phi) 

	%}}}
	%mask:  {{{
	md.mask=maskpsl(); % use maskpsl class (instead of mask) to store the ocean function as a ocean_levelset 
	mask=gmtmask(md.mesh.lat,md.mesh.long); 

	icemask=ones(md.mesh.numberofvertices,1);
	pos=find(mask==0);  icemask(pos)=-1;
	pos=find(sum(mask(md.mesh.elements),2)<3);   icemask(md.mesh.elements(pos))=-1;
	
	md.mask.ice_levelset=icemask;
	md.mask.ocean_levelset=zeros(md.mesh.numberofvertices,1);
	pos=find(md.mask.ice_levelset==1); md.mask.ocean_levelset(pos)=1;

	%make sure that the ice level set is all inclusive:
	md.mask.land_levelset=zeros(md.mesh.numberofvertices,1);
	md.mask.groundedice_levelset=-ones(md.mesh.numberofvertices,1); 
	% }}}
	%geometry:  {{{
	di=md.materials.rho_ice/md.materials.rho_water;
	md.geometry.thickness=ones(md.mesh.numberofvertices,1);
	md.geometry.surface=(1-di)*zeros(md.mesh.numberofvertices,1);
	md.geometry.base=md.geometry.surface-md.geometry.thickness;
	md.geometry.bed=md.geometry.base;
	% }}}
	%materials:  {{{
	md.initialization.temperature=273.25*ones(md.mesh.numberofvertices,1);
	md.materials.rheology_B=paterson(md.initialization.temperature);
	md.materials.rheology_n=3*ones(md.mesh.numberofelements,1);
	% }}}
	%Miscellaneous: {{{
	md.miscellaneous.name='slr';
	% }}}
	%Solution parameters:{{{
	md.slr.reltol=NaN;
	md.slr.abstol=1e-3;
	%}}}

	%eustatic run: 
	md.slr.eustatic=1; md.slr.rigid=0; md.slr.elastic=0;
	md=solve(md,SealevelriseSolutionEnum);
	Seustatic=md.results.SealevelriseSolution.Sealevel;
	
	%eustatic + rigid run: 
	md.slr.eustatic=1; md.slr.rigid=1; md.slr.elastic=0;
	md=solve(md,SealevelriseSolutionEnum);
	Srigid=md.results.SealevelriseSolution.Sealevel;
	
	%eustatic + rigid + elastic run: 
	md.slr.eustatic=1; md.slr.rigid=1; md.slr.elastic=1;
	md=solve(md,SealevelriseSolutionEnum);
	Selastic=md.results.SealevelriseSolution.Sealevel;


	%Fields and tolerances to track changes
	field_names     ={'Eustatic','Rigid','Elastic'};
	field_tolerances={1e-13,1e-13,1e-13};
	field_values={Seustatic,Srigid,Selastic};
