%NODALVALUE class definition
%
%   Usage:
%      nodalvalue=nodalvalue();
%      nodalvalue=nodalvalue('name','SealevelriseSNodalValue',...
%                    'definitionenum',Outputdefinition1Enum, 
%                    'model_enum',SealevelriseSEnum,...
%                    'node',1);

classdef nodalvalue
	properties (SetAccess=public)
		%nodalvalue
		name              = '';
		definitionenum   = NaN; %enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum
		model_enum       = NaN; %enum for field that is being retrieved
		node             = NaN; %for which node are we retrieving the value?
	end
	
	methods
		function self = nodalvalue(varargin) % {{{
			if nargin==0,
				self=setdefaultparameters(self);
			else
				%use provided options to change fields
				options=pairoptions(varargin{:});

				%get name
				self.name=getfieldvalue(options,'name','');
				self.definitionenum=getfieldvalue(options,'definitionenum');
				self.model_enum=getfieldvalue(options,'model_enum');
				self.node=getfieldvalue(options,'node',NaN);

			end
		end % }}}
		function self = setdefaultparameters(self) % {{{
		end % }}}
		function md = checkconsistency(self,md,solution,analyses) % {{{

			if ~ischar(self.name),
				error('nodalvalue error message: ''name'' field should be a string!');
			end
			md = checkfield(md,'fieldname','self.definitionenum','field',self.definitionenum,'values',[Outputdefinition1Enum:Outputdefinition100Enum]);

			md = checkfield(md,'fieldname','self.node','field',self.node,'values',[1:md.mesh.numberofvertices]);

		end % }}}
		function md = disp(self) % {{{
		
			disp(sprintf('   Nodalvalue:\n'));

			fielddisplay(self,'name','identifier for this nodalvalue response');
			fielddisplay(self,'definitionenum','enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum');
			fielddisplay(self,'model_enum','enum for field that is being retrieved');
			fielddisplay(self,'node','vertex index at which we retrieve the value');

		end % }}}
		function md = marshall(self,md,fid) % {{{

		WriteData(fid,'object',self,'fieldname','name','format','String');
		WriteData(fid,'object',self,'fieldname','definitionenum','format','Integer');
		WriteData(fid,'object',self,'fieldname','model_enum','format','Integer');
		WriteData(fid,'object',self,'fieldname','node','format','Integer');

		end % }}}
	end
end
