#include "./SealevelriseAnalysis.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
void SealevelriseAnalysis::CreateConstraints(Constraints* constraints,IoModel* iomodel){/*{{{*/
	/*No constraints*/
}/*}}}*/
void SealevelriseAnalysis::CreateLoads(Loads* loads, IoModel* iomodel){/*{{{*/
	/*No loads*/
}/*}}}*/
void SealevelriseAnalysis::CreateNodes(Nodes* nodes,IoModel* iomodel){/*{{{*/
	::CreateNodes(nodes,iomodel,SealevelriseAnalysisEnum,P1Enum);
}/*}}}*/
int  SealevelriseAnalysis::DofsPerNode(int** doflist,int domaintype,int approximation){/*{{{*/
	return 1;
}/*}}}*/
void SealevelriseAnalysis::UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	/*Create inputs: */
	iomodel->FetchDataToInput(elements,MaskIceLevelsetEnum);
	iomodel->FetchDataToInput(elements,MaskOceanLevelsetEnum);
	iomodel->FetchDataToInput(elements,MaskLandLevelsetEnum);
	iomodel->FetchDataToInput(elements,SealevelriseDeltathicknessEnum);

}/*}}}*/
void SealevelriseAnalysis::UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/

	int         nl;
	IssmDouble* love_h=NULL;
	IssmDouble* love_k=NULL;
	
	bool elastic=false;
	IssmDouble* G_elastic = NULL;
	int         M;

	/*some constant parameters: */
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseReltolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseAbstolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseMaxiterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseRigidEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseElasticEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseEustaticEnum));

	iomodel->FetchData(&elastic,SealevelriseElasticEnum);
	if(elastic){

		/*love numbers: */
		iomodel->FetchData(&love_h,&nl,NULL,SealevelriseLoveHEnum);
		iomodel->FetchData(&love_k,&nl,NULL,SealevelriseLoveKEnum);

		/*compute elastic green function for a range of angles*/
		const IssmDouble degacc=.01; M=reCast<int>(180/degacc+1);
		G_elastic=xNew<IssmDouble>(M);

		/*compute combined legendre + love number (elastic green function:*/
		for(int i=0;i<M;i++){ //watch out the <=
			IssmDouble alpha,x;
			alpha= reCast<IssmDouble>(i)*degacc * PI / 180.0;

			G_elastic[i]= (love_k[nl-1]-love_h[nl-1])/2.0/sin(alpha/2.0);
			for (int n=0;n<nl;n++) {
				IssmDouble Pn,Pn1,Pn2;
				IssmDouble deltalove;

				deltalove = (love_k[n]-love_k[nl-1]-love_h[n]+love_h[nl-1]);

				if(n==0)Pn=1;
				else if(n==1)Pn=cos(alpha);
				else Pn= ( (2*n-1)*cos(alpha)*Pn1 - (n-1)*Pn2 ) /n;
				Pn2=Pn1; Pn1=Pn;

				G_elastic[i] += deltalove*Pn;
			}
		}

		/*Avoid singularity at 0: */
		G_elastic[0]=G_elastic[1];
		parameters->AddObject(new DoubleVecParam(SealevelriseGElasticEnum,G_elastic,M));

		/*free ressources:*/
		xDelete<IssmDouble>(G_elastic);

		/*free ressources: */
		xDelete<IssmDouble>(love_h);
		xDelete<IssmDouble>(love_k);
		xDelete<IssmDouble>(G_elastic);
	}

}/*}}}*/

/*Finite Element Analysis*/
void           SealevelriseAnalysis::Core(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
ElementVector* SealevelriseAnalysis::CreateDVector(Element* element){/*{{{*/
	/*Default, return NULL*/
	return NULL;
}/*}}}*/
ElementMatrix* SealevelriseAnalysis::CreateJacobianMatrix(Element* element){/*{{{*/
_error_("Not implemented");
}/*}}}*/
ElementMatrix* SealevelriseAnalysis::CreateKMatrix(Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
ElementVector* SealevelriseAnalysis::CreatePVector(Element* element){/*{{{*/
_error_("not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element){/*{{{*/
	   _error_("not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index){/*{{{*/
	_error_("Not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::InputUpdateFromSolution(IssmDouble* solution,Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::UpdateConstraints(FemModel* femmodel){/*{{{*/
	/*Default, do nothing*/
	return;
}/*}}}*/
