/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	/*General: {{{*/
	FemModelEnum,
	/*}}}*/
	/*Model fields {{{*/
	AutodiffIsautodiffEnum, 
	AutodiffNumDependentsEnum,
	AutodiffNumDependentObjectsEnum,
	AutodiffDependentObjectNamesEnum,
	AutodiffDependentObjectTypesEnum,
	AutodiffDependentObjectIndicesEnum,
	AutodiffDependentObjectsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffNumIndependentObjectsEnum,
	AutodiffIndependentObjectNamesEnum,
	AutodiffIndependentObjectTypesEnum,
	AutodiffIndependentObjectsEnum,
	AutodiffJacobianEnum,
	AutodiffXpEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffMassFluxSegmentsPresentEnum,
	AutodiffKeepEnum,
	AutodiffObufsizeEnum,
	AutodiffLbufsizeEnum,
	AutodiffCbufsizeEnum,
	AutodiffTbufsizeEnum,
	AutodiffGcTriggerRatioEnum,
	AutodiffGcTriggerMaxSizeEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsGroundediceMeltingRateEnum,
	BasalforcingsFloatingiceMeltingRateEnum,
	BasalforcingsDeepwaterMeltingRateEnum,
	BasalforcingsDeepwaterElevationEnum,
	BasalforcingsUpperwaterElevationEnum,
	BasalforcingsMeltrateFactorEnum,
	BasalforcingsThresholdThicknessEnum,
	BasalforcingsUpperdepthMeltEnum,
	BasalforcingsMantleconductivityEnum,
	BasalforcingsNusseltEnum,
	BasalforcingsDtbgEnum,
	BasalforcingsPlumeradiusEnum,
	BasalforcingsTopplumedepthEnum,
	BasalforcingsBottomplumedepthEnum,
	BasalforcingsPlumexEnum,
	BasalforcingsPlumeyEnum,
	BasalforcingsCrustthicknessEnum,
	BasalforcingsUppercrustthicknessEnum,
	BasalforcingsUppercrustheatEnum,
	BasalforcingsLowercrustheatEnum,
	FloatingMeltRateEnum,
	LinearFloatingMeltRateEnum,
	MismipFloatingMeltRateEnum,
	MantlePlumeGeothermalFluxEnum,
	BedEnum,
	BaseEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DependentObjectEnum,
	StressbalanceAbstolEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReferentialEnum,
	StressbalanceReltolEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyLockEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
	StressbalanceSpcvxEnum,
	StressbalanceSpcvyEnum,
	StressbalanceSpcvzEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceVertexPairingEnum,
	StressbalanceViscosityOvershootEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	FlowequationBorderSSAEnum,
	FlowequationBorderHOEnum,
	FlowequationBorderFSEnum,
	FlowequationElementEquationEnum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsHOEnum,
	FlowequationIsFSEnum,
	FlowequationFeSSAEnum,
	FlowequationFeHOEnum,
	FlowequationFeFSEnum,
	FlowequationVertexEquationEnum,
	FrictionAsEnum,
	FrictionCoefficientEnum,
	FrictionCoefficientcoulombEnum,
	FrictionPEnum,
	FrictionQEnum,
	FrictionMEnum,
	FrictionCEnum,
	FrictionLawEnum,
	FrictionGammaEnum,
	FrictionFEnum,
	FrictionWaterLayerEnum,
	FrictionEffectivePressureEnum,
	FrictionCouplingEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyModelEnum,
	HydrologyshreveEnum,
	HydrologyshreveSpcwatercolumnEnum,
	HydrologyshreveStabilizationEnum,
	HydrologydcEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadResidualEnum,
	EffectivePressureEnum,
	EplHeadEnum,
	EplHeadOldEnum,
	EplHeadSlopeXEnum,
	EplHeadSlopeYEnum,
	EplZigZagCounterEnum,
	HydrologydcMaxIterEnum,
	HydrologydcRelTolEnum,
	HydrologydcSpcsedimentHeadEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcSedimentTransmitivityEnum,
	HydrologydcWaterCompressibilityEnum,
	HydrologydcSpceplHeadEnum,
	HydrologydcMaskEplactiveNodeEnum,
	HydrologydcMaskEplactiveEltEnum,
	HydrologydcEplCompressibilityEnum,
	HydrologydcEplPorosityEnum,
	HydrologydcEplInitialThicknessEnum,
	HydrologydcEplColapseThicknessEnum,
	HydrologydcEplMaxThicknessEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplThicknessOldEnum,
	HydrologydcEplThickCompEnum,
	HydrologydcEplConductivityEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologydcPenaltyLockEnum,
	HydrologydcEplflipLockEnum,
	HydrologydcBasalMoulinInputEnum,
	HydrologyLayerEnum,
	HydrologySedimentEnum,
	HydrologyEfficientEnum,
	HydrologySedimentKmaxEnum,
	HydrologysommersEnum,
	HydrologyHeadEnum,
	HydrologyGapHeightEnum,
	HydrologyBumpSpacingEnum,
	HydrologyBumpHeightEnum,
	HydrologyEnglacialInputEnum,
	HydrologyMoulinInputEnum,
	HydrologyReynoldsEnum,
	HydrologyNeumannfluxEnum,
	HydrologySpcheadEnum,
	HydrologyConductivityEnum,
	IndependentObjectEnum,
	InversionControlParametersEnum,
	InversionControlScalingFactorsEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionTypeEnum,
	InversionIncompleteAdjointEnum,
	InversionMaxParametersEnum,
	InversionMaxiterPerStepEnum,
	InversionMaxiterEnum,
	InversionMaxstepsEnum,
	InversionFatolEnum,
	InversionFrtolEnum,
	InversionGatolEnum,
	InversionGrtolEnum,
	InversionGttolEnum,
	InversionAlgorithmEnum,
	InversionMinParametersEnum,
	InversionNstepsEnum,
	InversionDxminEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionSurfaceObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskIceLevelsetEnum,
	MaskOceanLevelsetEnum,
	MaskLandLevelsetEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	DamageIsdamageEnum,
	DamageDEnum,
	DamageFEnum,
	DamageDbarEnum,
	DamageLawEnum,
	DamageC1Enum,
	DamageC2Enum,
	DamageC3Enum,
	DamageC4Enum,
	DamageElementinterpEnum,
	DamageHealingEnum,
	DamageStressThresholdEnum,
	DamageKappaEnum,
	DamageStabilizationEnum,
	DamageMaxiterEnum,
	DamageSpcdamageEnum,
	DamageMaxDamageEnum,
	DamageEquivStressEnum,
	DamageEvolutionNumRequestedOutputsEnum,
	DamageEvolutionRequestedOutputsEnum,
	DamageEnum,
	NewDamageEnum,
	StressIntensityFactorEnum,
	CalvingLawEnum,
	CalvingCalvingrateEnum,
	CalvingMeltingrateEnum,
	CalvingLevermannEnum,
	CalvingPiEnum,
	CalvingDevEnum,
	DefaultCalvingEnum,
	CalvingRequestedOutputsEnum,
	CalvinglevermannCoeffEnum,
	CalvinglevermannMeltingrateEnum,
	CalvingpiCoeffEnum,
	CalvingpiMeltingrateEnum,
	CalvingratexEnum,
	CalvingrateyEnum,
	CalvingratexAverageEnum,
	CalvingrateyAverageEnum,
	StrainRateparallelEnum,
	StrainRateperpendicularEnum,
	StrainRateeffectiveEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoSeawaterEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsMuWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MaterialsTemperateiceconductivityEnum,
	MaterialsLithosphereShearModulusEnum,
	MaterialsLithosphereDensityEnum,
	MaterialsMantleShearModulusEnum,
	MaterialsMantleDensityEnum,
	MaterialsEarthDensityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshLowerelementsEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshNumberofverticesEnum,
	MeshUpperelementsEnum,
	MeshVertexonbaseEnum,
	MeshVertexonsurfaceEnum,
	MeshVertexonboundaryEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MeshLatEnum,
	MeshLongEnum,
	MeshREnum,
	MeshElementtypeEnum,
	MeshSegmentsEnum,
	DomainTypeEnum,
	DomainDimensionEnum,
	Domain2DhorizontalEnum,
	Domain2DverticalEnum,
	Domain3DEnum,
	Domain3DsurfaceEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportSpcthicknessEnum,
	MasstransportStabilizationEnum,
	MasstransportVertexPairingEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportRequestedOutputsEnum,
	QmuIsdakotaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	QmuMassFluxSegmentsPresentEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	RiftsNumriftsEnum,
	RiftsRiftstructEnum,
	SettingsResultsOnNodesEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsRecordingFrequencyEnum,
	SettingsWaitonlockEnum,
	DebugProfilingEnum,
	ProfilingCurrentMemEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingSolutionTimeEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,
	ThermalIsenthalpyEnum,
	ThermalIsdynamicbasalspcEnum,
	ThermalReltolEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	ThermalNumRequestedOutputsEnum,
	ThermalRequestedOutputsEnum,
	GiaMantleViscosityEnum,
	GiaLithosphereThicknessEnum,
	ThicknessEnum,
	TimesteppingStartTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TimesteppingInterpForcingsEnum,
	TransientIssmbEnum,
	TransientIsstressbalanceEnum,
	TransientIsgroundinglineEnum,
	TransientIsmasstransportEnum,
	TransientIsthermalEnum,
	TransientIsgiaEnum,
	TransientIsdamageevolutionEnum,
	TransientIshydrologyEnum,
	TransientIscalvingEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	PotentialEnum,
	BalancethicknessSpcpotentialEnum,
	BalancethicknessApparentMassbalanceEnum,
	Balancethickness2MisfitEnum,
	BalancethicknessDiffusionCoefficientEnum,
	BalancethicknessCmuEnum,
	BalancethicknessOmegaEnum,
	BalancethicknessD0Enum,
	/*}}}*/
	/*Smb{{{*/
	SmbEnum,
	SmbAnalysisEnum,
	SmbSolutionEnum,
	SmbNumRequestedOutputsEnum,
	SmbRequestedOutputsEnum,
	SmbIsInitializedEnum,
	/*SMBforcing*/
	SMBforcingEnum,
	SmbMassBalanceEnum,
	/*SMBgemb*/
	SMBgembEnum,
	SmbInitDensityScalingEnum,
	SmbTaEnum,
	SmbVEnum,
	SmbDswrfEnum,
	SmbDlwrfEnum,
	SmbPEnum, 
	SmbSwfEnum, 
	SmbEAirEnum, 
	SmbPAirEnum,
	SmbTmeanEnum,
	SmbCEnum,
	SmbTzEnum,
	SmbVzEnum, 
	SmbDtEnum,
	SmbDzEnum,
	SmbAIdxEnum,
	SmbSwIdxEnum,
	SmbDenIdxEnum,
	SmbZTopEnum, 
	SmbDzTopEnum, 
	SmbDzMinEnum, 
	SmbZYEnum, 
	SmbZMaxEnum, 
	SmbZMinEnum, 
	SmbOutputFreqEnum, 
	SmbASnowEnum, 
	SmbAIceEnum, 
	SmbCldFracEnum, 
	SmbT0wetEnum, 
	SmbT0dryEnum, 
	SmbKEnum, 
	SmbDEnum,
	SmbReEnum,
	SmbGdnEnum,
	SmbGspEnum,
	SmbECEnum,
	SmbCondensationEnum,
	SmbWEnum,
	SmbAEnum,
	SmbTEnum,
	SmbIsgraingrowthEnum,
	SmbIsalbedoEnum,
	SmbIsshortwaveEnum,
	SmbIsthermalEnum,
	SmbIsaccumulationEnum,
	SmbIsmeltEnum,
	SmbIsdensificationEnum,
	SmbIsturbulentfluxEnum,
	/*SMBpdd*/
	SMBpddEnum,	
	SmbDelta18oEnum,
	SmbDelta18oSurfaceEnum,
	SmbIsdelta18oEnum,
	SmbIsmungsmEnum,
	SmbIsd18opdEnum,
	SmbPrecipitationsPresentdayEnum,
	SmbPrecipitationsLgmEnum,
	SmbTemperaturesPresentdayEnum,
	SmbTemperaturesLgmEnum,
	SmbPrecipitationEnum,
	SmbDesfacEnum,
	SmbS0pEnum,
	SmbS0tEnum,
	SmbRlapsEnum,
	SmbRlapslgmEnum,
	SmbPfacEnum,
	SmbTdiffEnum,
	SmbSealevEnum,
	SMBd18opddEnum,
	SmbDpermilEnum,
	SMBgradientsEnum,
	SmbMonthlytemperaturesEnum,
	SmbHrefEnum,
	SmbSmbrefEnum,
	SmbBPosEnum,
	SmbBNegEnum,
	SMBhenningEnum,
	SMBcomponentsEnum,
	SmbAccumulationEnum,
	SmbEvaporationEnum,
	SmbRunoffEnum,
	SMBmeltcomponentsEnum,
	SmbMeltEnum,
	SmbRefreezeEnum,
	SMBgcmEnum,
	/*TO BE REMOVED*/
	SmbIspddEnum,
	SmbIssmbgradientsEnum,
	/*}}}*/
	/*Solutions and Analyses{{{ */
	SolutionTypeEnum,
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointBalancethickness2AnalysisEnum,
	AdjointHorizAnalysisEnum,
	AnalysisCounterEnum,
	DefaultAnalysisEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	Balancethickness2AnalysisEnum,
	Balancethickness2SolutionEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	L2ProjectionEPLAnalysisEnum,
	L2ProjectionBaseAnalysisEnum,
	BedSlopeSolutionEnum,
	DamageEvolutionSolutionEnum,
	DamageEvolutionAnalysisEnum,
	StressbalanceAnalysisEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	EnthalpyAnalysisEnum,
	FlaimAnalysisEnum,
	FlaimSolutionEnum,
	HydrologyShreveAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologySommersAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	SurfaceNormalVelocityEnum,
	ExtrudeFromBaseAnalysisEnum,
	ExtrudeFromTopAnalysisEnum,
	DepthAverageAnalysisEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeSolutionEnum,
	SmoothAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	UzawaPressureAnalysisEnum,
	GiaSolutionEnum,
	GiaAnalysisEnum,
	MeshdeformationSolutionEnum,
	MeshdeformationAnalysisEnum,
	LevelsetAnalysisEnum,
	LevelsetStabilizationEnum,
	ExtrapolationAnalysisEnum,
	LsfReinitializationAnalysisEnum,
	/*}}}*/
	/*Approximations {{{*/
	ApproximationEnum,
	NoneApproximationEnum,
	SIAApproximationEnum,
	SSAApproximationEnum,
	SSAHOApproximationEnum,
	SSAFSApproximationEnum,
	L1L2ApproximationEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	FSApproximationEnum,
	FSvelocityEnum,
	FSpressureEnum,
	/*}}}*/
	/*Datasets {{{*/
	DataSetEnum,
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ContoursEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Objects {{{*/
	GenericParamEnum,
	AdolcParamEnum,
	BoolInputEnum,
	BoolParamEnum,
	ContourEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DoubleInputEnum,
	DoubleArrayInputEnum,
	DataSetParamEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementHookEnum,
	HookEnum,
	ExternalResultEnum,
	FileParamEnum,
	InputEnum,
	IntInputEnum,
	InputToExtrudeEnum,
	InputToL2ProjectEnum,
	InputToDepthaverageEnum,
	InputToSmoothEnum,
	SmoothThicknessMultiplierEnum,
	IntParamEnum,
	IntVecParamEnum,
	TransientParamEnum,
	MaticeEnum,
	MatdamageiceEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	NumericalfluxTypeEnum,
	NeumannfluxEnum,
	ParamEnum,
	MoulinEnum,
	PengridEnum,
	PenpairEnum,
	ProfilerEnum,
	MatrixParamEnum,
	MassconEnum,
	MassconNameEnum,
	MassconDefinitionenumEnum,
	MassconLevelsetEnum,
	MassconaxpbyEnum,
	MassconaxpbyNameEnum,
	MassconaxpbyDefinitionenumEnum,
	MassconaxpbyNamexEnum,
	MassconaxpbyNameyEnum,
	MassconaxpbyAlphaEnum,
	MassconaxpbyBetaEnum,
	NodeSIdEnum,
	VectorParamEnum,
	RiftfrontEnum,
	RiftfrontTypeEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	StringArrayParamEnum,
	StringParamEnum,
	SegEnum,
	SegInputEnum,
	TriaEnum,
	TriaInputEnum,
	TetraEnum,
	TetraInputEnum,
	PentaEnum,
	PentaInputEnum,
	VertexEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	/*}}}*/
	/*Fill {{{*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Rift state {{{*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Inputs {{{*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BalancethicknessMisfitEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConvergedEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	InternalEnum,
	MassFluxEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	PressureEnum,
	PressurePicardEnum,
	AndroidFrictionCoefficientEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	TemperaturePDDEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsMisfitEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzSSAEnum,
	VzHOEnum,
	VzPicardEnum,
	VzFSEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessAcrossGradientEnum,
	ThicknessPositiveEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	RheologyBAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	DrivingStressXEnum,
	DrivingStressYEnum,
	SigmaNNEnum,
	StressTensorEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	StressMaxPrincipalEnum,
	DeviatoricStressEnum,
	DeviatoricStressxxEnum,
	DeviatoricStressxyEnum,
	DeviatoricStressxzEnum,
	DeviatoricStressyyEnum,
	DeviatoricStressyzEnum,
	DeviatoricStresszzEnum,
	DeviatoricStresseffectiveEnum,
	StrainRateEnum,
	StrainRatexxEnum,
	StrainRatexyEnum,
	StrainRatexzEnum,
	StrainRateyyEnum,
	StrainRateyzEnum,
	StrainRatezzEnum,
	DivergenceEnum,
	MaxDivergenceEnum,
	GiaCrossSectionShapeEnum,
	GiadWdtEnum,
	GiaWEnum,
	/*}}}*/
	/*Element Interpolations{{{*/
	P0Enum,
	P0ArrayEnum,
	P1Enum,
	P1DGEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P2Enum,
	P2bubbleEnum,
	P2bubblecondensedEnum,
	P2xP1Enum,
	P1xP2Enum,
	P1xP3Enum,
	P2xP4Enum,
	P1P1Enum,
	P1P1GLSEnum,
	MINIEnum,
	MINIcondensedEnum,
	TaylorHoodEnum,
	LATaylorHoodEnum,
	XTaylorHoodEnum,
	OneLayerP4zEnum,
	CrouzeixRaviartEnum,
	LACrouzeixRaviartEnum,
	/*}}}*/
	/*Results{{{*/
	SaveResultsEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	JEnum,
	StringExternalResultEnum,
	StepEnum,
	TimeEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Output Definitions{{{*/
	OutputdefinitionEnum,
	Outputdefinition1Enum,
	Outputdefinition2Enum,
	Outputdefinition3Enum,
	Outputdefinition4Enum,
	Outputdefinition5Enum,
	Outputdefinition6Enum,
	Outputdefinition7Enum,
	Outputdefinition8Enum,
	Outputdefinition9Enum,
	Outputdefinition10Enum,
	Outputdefinition11Enum,
	Outputdefinition12Enum,
	Outputdefinition13Enum,
	Outputdefinition14Enum,
	Outputdefinition15Enum,
	Outputdefinition16Enum,
	Outputdefinition17Enum,
	Outputdefinition18Enum,
	Outputdefinition19Enum,
	Outputdefinition20Enum,
	Outputdefinition21Enum,
	Outputdefinition22Enum,
	Outputdefinition23Enum,
	Outputdefinition24Enum,
	Outputdefinition25Enum,
	Outputdefinition26Enum,
	Outputdefinition27Enum,
	Outputdefinition28Enum,
	Outputdefinition29Enum,
	Outputdefinition30Enum,
	Outputdefinition31Enum,
	Outputdefinition32Enum,
	Outputdefinition33Enum,
	Outputdefinition34Enum,
	Outputdefinition35Enum,
	Outputdefinition36Enum,
	Outputdefinition37Enum,
	Outputdefinition38Enum,
	Outputdefinition39Enum,
	Outputdefinition40Enum,
	Outputdefinition41Enum,
	Outputdefinition42Enum,
	Outputdefinition43Enum,
	Outputdefinition44Enum,
	Outputdefinition45Enum,
	Outputdefinition46Enum,
	Outputdefinition47Enum,
	Outputdefinition48Enum,
	Outputdefinition49Enum,
	Outputdefinition50Enum,
	Outputdefinition51Enum,
	Outputdefinition52Enum,
	Outputdefinition53Enum,
	Outputdefinition54Enum,
	Outputdefinition55Enum,
	Outputdefinition56Enum,
	Outputdefinition57Enum,
	Outputdefinition58Enum,
	Outputdefinition59Enum,
	Outputdefinition60Enum,
	Outputdefinition61Enum,
	Outputdefinition62Enum,
	Outputdefinition63Enum,
	Outputdefinition64Enum,
	Outputdefinition65Enum,
	Outputdefinition66Enum,
	Outputdefinition67Enum,
	Outputdefinition68Enum,
	Outputdefinition69Enum,
	Outputdefinition70Enum,
	Outputdefinition71Enum,
	Outputdefinition72Enum,
	Outputdefinition73Enum,
	Outputdefinition74Enum,
	Outputdefinition75Enum,
	Outputdefinition76Enum,
	Outputdefinition77Enum,
	Outputdefinition78Enum,
	Outputdefinition79Enum,
	Outputdefinition80Enum,
	Outputdefinition81Enum,
	Outputdefinition82Enum,
	Outputdefinition83Enum,
	Outputdefinition84Enum,
	Outputdefinition85Enum,
	Outputdefinition86Enum,
	Outputdefinition87Enum,
	Outputdefinition88Enum,
	Outputdefinition89Enum,
	Outputdefinition90Enum,
	Outputdefinition91Enum,
	Outputdefinition92Enum,
	Outputdefinition93Enum,
	Outputdefinition94Enum,
	Outputdefinition95Enum,
	Outputdefinition96Enum,
	Outputdefinition97Enum,
	Outputdefinition98Enum,
	Outputdefinition99Enum,
	Outputdefinition100Enum,   
	OutputdefinitionListEnum,
	MassfluxatgateEnum,
	MassfluxatgateNameEnum,
	MassfluxatgateDefinitionenumEnum,
	MassfluxatgateSegmentsEnum,
	MisfitNameEnum,
	MisfitDefinitionenumEnum,
	MisfitModelEnumEnum,
	MisfitObservationEnum,
	MisfitObservationEnumEnum,
	MisfitLocalEnum,
	MisfitTimeinterpolationEnum,
	MisfitWeightsEnum,
	MisfitWeightsEnumEnum,
	SurfaceObservationEnum,
	WeightsSurfaceObservationEnum,
	VxObsEnum,
	WeightsVxObsEnum,
	VyObsEnum,
	WeightsVyObsEnum,
	/*}}}*/
	/*Responses{{{*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	FloatingAreaEnum,
	GroundedAreaEnum,
	IceMassEnum,
	IceVolumeEnum,
	IceVolumeAboveFloatationEnum,
	TotalSmbEnum,
	/*}}}*/
	/*Relaxation{{{*/
	AbsoluteEnum,
	IncrementalEnum,
	AugmentedLagrangianREnum,
	AugmentedLagrangianRhopEnum,
	AugmentedLagrangianRlambdaEnum,
	AugmentedLagrangianRholambdaEnum,
	AugmentedLagrangianThetaEnum,
	/*}}}*/
	/*Grounding Line{{{*/
	NoneEnum,
	AggressiveMigrationEnum,
	SoftMigrationEnum,
	SubelementMigrationEnum,
	SubelementMigration2Enum,
	ContactEnum,
	GroundingOnlyEnum,
	MaskGroundediceLevelsetEnum,
	/*}}}*/
	/*Gauss{{{*/
	GaussSegEnum,
	GaussTriaEnum,
	GaussTetraEnum,
	GaussPentaEnum,
	/*}}}*/
	/*Solver{{{*/
	FSSolverEnum,
	/*}}}*/
	/*Parameters{{{*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputBufferPointerEnum,
	OutputBufferSizePointerEnum,
	OutputFilePointerEnum,
	ToolkitsFileNameEnum,
	RootPathEnum,
	OutputFileNameEnum,
	InputFileNameEnum,
	LockFileNameEnum,
	RestartFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	VerboseEnum,
	/*}}}*/
	/*Interpolation {{{*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Coordinate Systems{{{*/
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Toolkits{{{*/
	DenseEnum,
	MpiDenseEnum,
	MpiSparseEnum,
	SeqEnum,
	MpiEnum,
	MumpsEnum,
	GslEnum,
	/*}}}*/
	/*Options{{{*/
	OptionEnum,
	GenericOptionEnum,
	OptionCellEnum,
	OptionStructEnum,
	/*}}}*/
	/*Rheology law (move to Material) {{{*/
	CuffeyEnum,
	PatersonEnum,
	ArrheniusEnum,
	LliboutryDuvalEnum,
	/*}}}*/
	/*Levelset related enums (will be moved to appropriate place when finished){{{*/
	TransientIslevelsetEnum,
	SpcLevelsetEnum,
	ExtrapolationVariableEnum,
	IceMaskNodeActivationEnum,
	LevelsetfunctionSlopeXEnum,
	LevelsetfunctionSlopeYEnum,
	LevelsetfunctionPicardEnum,
	/*}}}*/
	/*Sea Level Rise*/
	SealevelriseSolutionEnum,
	SealevelriseAnalysisEnum,
	SealevelriseSEnum,
	SealevelriseDeltathicknessEnum,
	SealevelriseMaxiterEnum,
	SealevelriseReltolEnum,
	SealevelriseAbstolEnum,
	SealevelriseLoveHEnum,
	SealevelriseLoveKEnum,
	SealevelriseRigidEnum,
	SealevelriseElasticEnum,
	SealevelriseEustaticEnum,
	SealevelriseGElasticEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
