#include "./SealevelriseAnalysis.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

/*Model processing*/
void SealevelriseAnalysis::CreateConstraints(Constraints* constraints,IoModel* iomodel){/*{{{*/
	/*No constraints*/
}/*}}}*/
void SealevelriseAnalysis::CreateLoads(Loads* loads, IoModel* iomodel){/*{{{*/
	/*No loads*/
}/*}}}*/
void SealevelriseAnalysis::CreateNodes(Nodes* nodes,IoModel* iomodel){/*{{{*/
	::CreateNodes(nodes,iomodel,SealevelriseAnalysisEnum,P1Enum);
}/*}}}*/
int  SealevelriseAnalysis::DofsPerNode(int** doflist,int domaintype,int approximation){/*{{{*/
	return 1;
}/*}}}*/
void SealevelriseAnalysis::UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type){/*{{{*/

	/*Update elements: */
	int counter=0;
	for(int i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type,P1Enum);
			counter++;
		}
	}

	/*Create inputs: */
	iomodel->FetchDataToInput(elements,MaskIceLevelsetEnum);
	iomodel->FetchDataToInput(elements,MaskOceanLevelsetEnum);
	iomodel->FetchDataToInput(elements,MaskLandLevelsetEnum);
	iomodel->FetchDataToInput(elements,SealevelriseDeltathicknessEnum);

}/*}}}*/
void SealevelriseAnalysis::UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum){/*{{{*/

	int         nl;
	IssmDouble* love_h=NULL;
	IssmDouble* love_k=NULL;
	
	bool        legendre_precompute=false;
	IssmDouble* legendre_coefficients=NULL;
	int         M;

	/*some constant parameters: */
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseReltolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseAbstolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseMaxiterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseRigidEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseElasticEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseEustaticEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseLegendrePrecomputeEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SealevelriseStoreGreenFunctionsEnum));

	/*love numbers: */
	iomodel->FetchData(&love_h,&nl,NULL,SealevelriseLoveHEnum);
	iomodel->FetchData(&love_k,&nl,NULL,SealevelriseLoveKEnum);
	parameters->AddObject(new DoubleVecParam(SealevelriseLoveHEnum,love_h,nl));
	parameters->AddObject(new DoubleVecParam(SealevelriseLoveKEnum,love_k,nl));

	/*legendre coefficients: */
	iomodel->Constant(&legendre_precompute,SealevelriseLegendrePrecomputeEnum);
	if(legendre_precompute){

		/*compute values at which to evaluate the legendre polynomical values:*/
		const IssmDouble degacc=.01; M=reCast<int>(180/degacc+1);
		IssmDouble* x=xNew<IssmDouble>(M);
		for(int i=0;i<=M;i++){ //watch out the <=
			x[i]=-cos( (reCast<IssmDouble>(i)*degacc) * PI / 180.0);
		}
		/*compute legendre coefficient matrix:*/
		legendre_coefficients=p_polynomial_value(M,nl-1,x);
		parameters->AddObject(new DoubleMatParam(SealevelriseLegendreCoefficientsEnum,legendre_coefficients,nl,M));

		/*free ressources:*/
		xDelete<IssmDouble>(x);
	}

	/*free ressources: */
	xDelete<IssmDouble>(love_h);
	xDelete<IssmDouble>(love_k);
	xDelete<IssmDouble>(legendre_coefficients);

}/*}}}*/

/*Finite Element Analysis*/
void           SealevelriseAnalysis::Core(FemModel* femmodel){/*{{{*/
	_error_("not implemented");
}/*}}}*/
ElementVector* SealevelriseAnalysis::CreateDVector(Element* element){/*{{{*/
	/*Default, return NULL*/
	return NULL;
}/*}}}*/
ElementMatrix* SealevelriseAnalysis::CreateJacobianMatrix(Element* element){/*{{{*/
_error_("Not implemented");
}/*}}}*/
ElementMatrix* SealevelriseAnalysis::CreateKMatrix(Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
ElementVector* SealevelriseAnalysis::CreatePVector(Element* element){/*{{{*/
_error_("not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element){/*{{{*/
	   _error_("not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index){/*{{{*/
	_error_("Not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::InputUpdateFromSolution(IssmDouble* solution,Element* element){/*{{{*/
	_error_("not implemented yet");
}/*}}}*/
void           SealevelriseAnalysis::UpdateConstraints(FemModel* femmodel){/*{{{*/
	/*Default, do nothing*/
	return;
}/*}}}*/
