/*!\file: sealevelrise_core.cpp
 * \brief: core of the SLR solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void sealevelrise_core(FemModel* femmodel){

	Vector<IssmDouble> *Sg    = NULL;
	Vector<IssmDouble> *Sg_eustatic    = NULL; 
	bool save_results;
	int configuration_type;

	if(VerboseSolution()) _printf0_("   computing sea level rise\n");

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	/*set configuration: */
	femmodel->SetCurrentConfiguration(SealevelriseAnalysisEnum);

	/*call two sub cores:*/
	Sg_eustatic=sealevelrise_core_eustatic(femmodel); //generalized eustatic (Farrel and Clark, Eq 4, 1st, 3rd and 4rd terms on the RHS.

	Sg=sealevelrise_core_noneustatic(femmodel,Sg_eustatic); //sea-level rise dependent terms (2nd and 5th terms on the RHS)

	/*get results out:*/
	InputUpdateFromVectorx(femmodel,Sg,SealevelriseSEnum,VertexSIdEnum);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		int outputs[1] = {SealevelriseSEnum};
		femmodel->RequestedOutputsx(&femmodel->results,&outputs[0],1);
	}
	delete Sg;
	delete Sg_eustatic;
}
