/*\file UpdateFromInputs.c
 *\brief: update datasets with new parameter inputs
 */

#include "./UpdateFromInputs.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	ParameterInputs* inputs=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateFromInputsUsage);

	/*Input datasets: */
	FetchData((void**)&elements,NULL,NULL,ELEMENTSIN,"DataSet",NULL);
	FetchData((void**)&nodes,NULL,NULL,NODESIN,"DataSet",NULL);
	FetchData((void**)&loads,NULL,NULL,LOADSIN,"DataSet",NULL);
	FetchData((void**)&materials,NULL,NULL,MATERIALSIN,"DataSet",NULL);

	/*Fetch inputs: */
	ParameterInputsInit(&inputs,INPUTS);

	/*!Generate internal degree of freedom numbers: */
	UpdateFromInputsx(elements,nodes,loads, materials,inputs);

	/*write output datasets: */
	WriteData(ELEMENTS,elements,0,0,"DataSet",NULL);
	WriteData(NODES,nodes,0,0,"DataSet",NULL);
	WriteData(LOADS,loads,0,0,"DataSet",NULL);
	WriteData(MATERIALS,materials,0,0,"DataSet",NULL);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	DeleteParameterInputs(&inputs);

	/*end module: */
	MODULEEND();
}

void UpdateFromInputsUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,nodes,loads, materials] = %s(elements,nodes,loads, materials,inputs);\n",__FUNCT__);
	_printf_("\n");
}
