/*\file Test.c
 *\brief:  test module. do whatever you want in here
 */

#include "./Test.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&TestUsage);

	double* pr=mxGetPr(prhs[0]);
	int M=mxGetM(prhs[0]);
	int N=mxGetM(prhs[0]);
	mwIndex* ir=mxGetIr(prhs[0]);
	mwIndex* jc=mxGetJc(prhs[0]);
	int     nzmax=(int)mxGetNzmax(prhs[0]);

	int i;
	printf("nzmax %i\n",nzmax);
	printf("jc:\n");
	for(i=0;i<N+1;i++){
		printf("%i\n",jc[i]);
	}
	printf("ir vale:\n");
	for(i=0;i<nzmax;i++){
		printf("%i %g\n",ir[i],pr[i]);
	}	


	/*end module: */
	MODULEEND();
}

void TestUsage(void)
{
	_printf_("\n");
	_printf_("   usage: %s(whatever in here);\n",__FUNCT__);
	_printf_("\n");
}
