function [u]=griddata_nearest_matrix(x_m,y_m,u_m,x,y)
%GRIDDATA_NEAREST_MATRIX - interpolate a function on a grid
%
%   This function returns interpolated u_m function of x_m and y_m,
%   on the grid defined by x and y.
%   INPUT x_m,y_m,u_M, x,y where x_m,y_m and u_m are 2d matrices, 
%   and x,y are one dimensional vectors,
%   See griddata_nearest_matrix for the case where x_m,y_m and u_m are matrices 
%   and x,y are vectores.
%   See griddata_perso for a user defined version of griddata ( with fuzz coeff).
%
%   Usage:
%      [u]=griddata_nearest_matrix(x_m,y_m,u_m,x,y)

u=zeros(length(x),1);
count=0;
for n=1:length(x),
    if n>length(x)/10*count,
      disp(n/length(x)*100);
      count=count+1;
   end

   [posx,posy]=find_coord_matrix(x_m,y_m,x(n),y(n));
   u(n)=u_m(posx,posy);
end
