function res=mean_congrid(a,n,choice);
%MEAN_CONGRID - average the values around a pixel
%
%   INPUT a,n,choice, where a is the matrix, and n the size of the area averaged around
%   one pixel, odd number. choice=1 if the NaN values remain NaN values.
%
%   Usage:
%      res=mean_congrid(a,n,choice)

s=size(a);
aa=a;
pos=find(isnan(aa));
aa(pos)=0;

if (mod(n,2)==0),
   disp('Cannot rebin, the dimensions of the matrix and n are not compatible');
   break
end
mm=(n-1)/2;

res=zeros(s(1),s(2));

for m=mm+1:s(1)-mm,
   if mod(m,10)==0,
      disp(m/s(1)*100);
   end
   
   for l=mm+1:s(2)-mm,
      
      
      if sum(sum(~isnan(a(m-mm:m+mm,l-mm:l+mm))))~=0,
      res(m,l)=sum(...
                   sum(...
                   ~isnan(...
                          a(m-mm:m+mm,l-mm:l+mm)...
                          ).*...
                          aa(m-mm:m+mm,l-mm:l+mm)...
                       )...
                   )...
                   /sum(sum(~isnan(a(m-mm:m+mm,l-mm:l+mm))));
             else
                res(m,l)=NaN;
             end
             
   end
end

if choice==1,
   pos=find(isnan(a));
   res(pos)=NaN;
end

   






