function bool=ispolygon(x,y);
%ISPOLYGON - indicate if an outline is a polygon or not
%
%   Usage:
%      bool=ispolygon(x,y)

bool=0;
pairs_x=zeros(length(x),2);
pairs_y=zeros(length(x),2);

for i=1:length(x)-1,
   pairs_x(i,:)=[x(i) x(i+1)];
   pairs_y(i,:)=[y(i) y(i+1)];
end
pairs_x(length(x),:)=[x(length(x)) x(1)];
pairs_y(length(x),:)=[y(length(x)) y(1)];

for n=1:length(pairs_x)-1,

	pair_nx=zeros(length(x)-n,2);
   pair_ny=zeros(length(x)-n,2);
   for j=n:length(x)-1,
      pair_nx(j-n+1,:)=pairs_x(n,:);
      pair_ny(j-n+1,:)=pairs_y(n,:);
   end
   test_x=pairs_x(n+1:length(x),:);
   test_y=pairs_y(n+1:length(x),:);
[IS,S]=iscross(pair_nx',pair_ny',test_x',test_y');
bool=bool+length(find(IS==1));
end
if bool>=1,
   bool=1;
end

bool=-bool;

disp('Attention, ispolygon a ete modifie, retourne 1 si oui, 0 si non');
