function bool=insidehull(X,Y,target);
%INSIDEHULL - return wheter target belongs to the convex hull of X,Y or not.
%
%   Usage:
%      bool=insidehull(X,Y,target)

%INPUT X,Y, target
X_exp=[X;target(1)];
Y_exp=[Y;target(2)];

K=convhull(X,Y);
K_exp=convhull(X_exp,Y_exp);
K_area=polyarea(X(K),Y(K));
K_exp_area=polyarea(X_exp(K_exp),Y_exp(K_exp));

bool=(K_exp_area<=K_area);


