function expwriteasvertices(a,filename);
%EXPWRITEASVERTIVES - write an Argus file from a structure given in input
%
%   This routine write an Argus file form a structure containing the fields:
%   x and y of the coordinates of the points.
%   The first argument is the structure containing the points coordinates 
%   and the second one the file to be write.
%
%   Usage:
%      expwriteasvertices(a,filename)
% 
%   Example:
%      expwriteasvertices(coordstruct,'domainoutline.exp')
%
%   See also EXPDOC, EXPREAD, EXPWRITE

fid=fopen(filename,'w');
for n=1:length(a.x),
   
	fprintf(fid,'%s\n','## Name:');
	fprintf(fid,'%s\n','## Icon:0');
	fprintf(fid,'%s\n','# Points Count  Value');
	fprintf(fid,'1 1.\n');
	fprintf(fid,'%s\n','# X pos Y pos');
	fprintf(fid,'%f %f\n\n',[a.x(n) a.y(n)]);

end
fclose(fid);
