function [handle_struct]=antscale(length,fontsize);
%ANTSCALE - ???
%
%   Usage:
%      [handle_struct]=antscale(length,fontsize)

if ((nargin~=2) | (nargout~=1)),
	help antscale;
	return;
end

disp('Position of scale');
[x,y]=ginput(1);

A=[x-length/2 y+length/10];
B=[x-length/2 y];
C=[x-length/4 y];
D=[x-length/4 y+length/10/4];
E=[x y];
F=[x y+length/10/2];
G=[x+length/4 y]; 
H=[x+length/4 y+length/10/4];
I=[x+length/2 y];
J=[x+length/2 y+length/10];

lines=[A;B;C;D;C;E;F;E;G;H;G;I;J];

h=line(lines(:,1),lines(:,2));
set(h,'Color','k','LineWidth',1.5);

t1=text(x-length/2,y+1.5*length/10,'0');
set(t1,'FontSize',fontsize,'HorizontalAlignment','center')
t2=text(x,y+1.5*length/10,num2str(length/1000/2));
set(t2,'FontSize',fontsize,'HorizontalAlignment','center')
t3=text(x+length/2,y+1.5*length/10,[num2str(length/1000) ' km']);
set(t3,'FontSize',fontsize,'HorizontalAlignment','center')

handle_struct(1).h=h;
handle_struct(2).h=t1;
handle_struct(3).h=t2;
handle_struct(4).h=t3;

