function [matrix_bar, matrix_xbar, matrix_ybar]=...
   bar_maker(nel,nods,index,alpha,beta)
%BAR_MAKER - builds some useful matrices
%
%   matrix bar is used to evaluate the mean value of a parameter 
%   over the elements as follows:
%   o Pelements=matrix_bar*Pnodes
%   The two other matrices matrix xbar and matrix ybar are used 
%   to evaluate a parameter derivative over the elements with respect
%   to x or y exactly as above
%
%   Usage:
%      [matrix_bar, matrix_xbar, matrix_ybar]=bar_maker(nel,nods,index,alpha,beta)

row=zeros(nel*3,1);
col=zeros(nel*3,1);
value=zeros(nel*3,1);
valuex=zeros(nel*3,1);
valuey=zeros(nel*3,1);
count=-nel+1;		 
for m=1:3
    count=count+nel;
    row(count:count+nel-1)=[1:nel]';
    col(count:count+nel-1)=index(:,m);

    value(count:count+nel-1)=1/3 ;
    valuex(count:count+nel-1)=alpha(:,m);
    valuey(count:count+nel-1)=beta(:,m) ;
end

matrix_bar=sparse(row,col,value,nel,nods);
matrix_xbar=sparse(row,col,valuex,nel,nods);
matrix_ybar=sparse(row,col,valuey,nel,nods);
